/*
	ico.h
	Ver.1.0   1999-09-16  T.Ogihara
*/
#include "common.h"

#define  SizeOfANDCluster(x)	((((x) >> 3) + 3) & ~3)

typedef struct {
	short	x;	/* width in pixels, be 16, 32, or 64 */
	short	y;	/* height in pixels, be 16, 32, or 64 */
	short	colors;	/* number of palette-colors, must be 2, 8 or 16 */
	short	planes;	/* number of color planes */
	short	bits;	/* 1: 8dot/byte   4: 2dot/byte */
	long	size;	/* image size in bytes */
	long	offset; /* image begining position */
	paltype	*palette;
} icoHeader;

void put_short(int c, FILE *fp);
void put_long(long c, FILE *fp);

icoHeader *loadIcoHeaders(FILE *fp, int *num, int *errcode);
void freeIcoHeaders(icoHeader *ih, int num);
void writeIcoHeaders(FILE *fp, icoHeader *ih, int num);

unsigned char *imageMap(FILE *fp, icoHeader *ih);
void writeImageMap(FILE *fp, icoHeader *ih, unsigned char *map);
