#include  <stdio.h>
#include  <libc.h>

#include  "ico.h"

static int get_short(FILE *fp)
{
	int c = getc(fp);
	return ((getc(fp) << 8) | c);
}

static long get_long(FILE *fp)
{
	long c = get_short(fp);
	return ((get_short(fp) << 16) | c);
}

void put_short(int c, FILE *fp)
{
	fputc(c & 0xff, fp);
	fputc((c >> 8) & 0xff, fp);
}

void put_long(long c, FILE *fp)
{
	put_short(c & 0xffff, fp);
	put_short((c >> 16) & 0xffff, fp);
}

static icoHeader *getIcoHeader(FILE *fp, int *errcode)
{
	static icoHeader	ico;

	*errcode = 0;
	ico.x = getc(fp);
	ico.y = getc(fp);
	if ((ico.colors = getc(fp)) == 0)
		ico.colors = 256;
	(void)getc(fp);		/* reserved */
	ico.planes = get_short(fp);
	if ((ico.bits = get_short(fp)) == 0) {
		/* some ico-files have invalid value */
		if (ico.colors == 2)
			ico.bits = 1;
		else
			ico.bits = (ico.colors == 16) ? 4 : 8;
	}
	ico.size = get_long(fp);
	ico.offset = get_long(fp);
	ico.palette = NULL;
	if (feof(fp)) {
		*errcode = Err_SHORT;
		return NULL;
	}
	return &ico;
}

icoHeader *loadIcoHeaders(FILE *fp, int *num, int *errcode)
	/* This function returns a sequence of icoHeader. */
{
	int	i, numberOfIcon;
	icoHeader *seq;

	*errcode = 0;
	if (get_short(fp) != 0x00 || get_short(fp) != 0x01 ||
			(numberOfIcon = get_short(fp)) <= 0) {
		*errcode = Err_FORMAT;
		*num = 0;
		return NULL;
	}
	*num = numberOfIcon;
	seq = (icoHeader *)malloc(sizeof(icoHeader) * numberOfIcon);
	if (seq == NULL) {
		*errcode = Err_MEMORY;
		return NULL;
	}
	for (i = 0; i < numberOfIcon; i++) {
		icoHeader *icop;
		int	err;
		icop = getIcoHeader(fp, &err);
		if (icop == NULL) {
			*errcode = err;
			*num = i;
			if (i == 0) {
				free((void *)seq);
				return NULL;
			}
			break;
		}
		seq[i] = *icop;
	}
	return seq;
}

void freeIcoHeaders(icoHeader *ih, int num)
{
	int	i;

	if (ih == NULL)
		return;
	for (i = 0; i < num; i++) {
		if (ih[i].palette)
			free((void *)ih[i].palette);
	}
	free((void *)ih);
}


static int amountOfEntry(icoHeader *ih)
{
	int	amo = 40;	/* Header */
	amo += (ih->x * ih->y) * ih->bits / 8;	/* XOR */
	amo += ih->y * SizeOfANDCluster(ih->x);	/* AND */
	amo += ih->colors * 4;			/* Palette */
	return amo;
}

void writeIcoHeaders(FILE *fp, icoHeader *ih, int num)
	/* This function writes a sequence of icoHeader. */
{
	int	i, amount;
	long	offsets;

	put_short(0x00, fp);
	put_short(0x01, fp);
	put_short(num, fp);
	offsets = 6 + 16 * num;
	for (i = 0; i < num; i++) {
		fputc(ih[i].x, fp);
		fputc(ih[i].y, fp);
		if (ih[i].colors >= 256)
			fputc(0, fp);
		else
			fputc(ih[i].colors, fp);
		fputc(0, fp);	/* reserved */
		put_short(ih[i].planes, fp);
		put_short(ih[i].bits, fp);
		amount = amountOfEntry(&ih[i]);
		put_long(amount, fp);
		put_long(offsets, fp);
		offsets += amount;
	}
}
