/* GameGui.m created by veilljf on Thu 03-Dec-1998 */

#import "GameGUI.h"
#import "GameModel.h"
#import <Foundation/Foundation.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSWindow.h>
#import <AppKit/NSMenu.h>
#import <AppKit/NSSavePanel.h>


@implementation GameGUI

+ fileExtension
{
    return @"solitaireGame";
}

- initWithModel:m
{
    [self setModel:m];
    return self;
}

- (void)dealloc
{
    [model release];
    [super dealloc];
}

- model
{
    return model;
}

- (void)setModel:m
{
    if(m != model) {
        [model release];
        model = [m retain];
    }
}

- (void)setBackground:(id)bg onWindow:(id)win
/*" Will set background of the window to be bg.  Where bg is a background object as define in a future frameworks."*/
{
    
}

- (void)setDefaultBackgroundOnWindow:(id)win
{
    id desktopColor = [[[NSApplication sharedApplication] delegate] backgroundColor];
    [win setBackgroundColor:desktopColor];
}

- (void)restartGame:sender
{
    [model restartGame];
}

- (void)startGame:sender
{
    [model newGame];
}

- (void)showUp
{
    [NSBundle loadNibNamed:@"SmallGame" owner:self];
    [self setDefaultBackgroundOnWindow:gameWindow];
    [self setupGame];
}

- (void)setupGame
    /*" SHOULD overide this method to associate our view with the different model classes. "*/
{
    // subclass responsability
}

- (void)windowWillClose:(NSNotification *)aNotification
{
    // release ourself
    [model endGame:aNotification];
    [[NSUserDefaults standardUserDefaults] synchronize];
    [self release];
}


- (void)saveGame:(id)sender
{
    id filename = [gameWindow representedFilename];

    if([filename isEqual:@""]) {
        [self saveAs:filename];
    }
    else
    {
        [self saveOnFileName:filename];
        [gameWindow setDocumentEdited:NO];
    }
}

- (void)saveAs:(id)sender
{
    id filename = [gameWindow representedFilename];
    int runResult = NSOKButton;

    NSSavePanel *sp;

    /* create or get the shared instance of NSSavePanel */
    sp = [NSSavePanel savePanel];

    /* set up new attributes */
    [sp setRequiredFileType:[[self class] fileExtension]];

    /* display the NSSavePanel */
    runResult = [sp runModalForDirectory:NSHomeDirectory() file:@""];
    filename = [sp filename];

    /* if successful, save file under designated name */
    if (runResult == NSOKButton) {
        [self saveOnFileName:filename];
        [gameWindow setTitleWithRepresentedFilename:filename];
        [gameWindow setDocumentEdited:NO];
    }
}

- (void)saveOnFileName:(id)filename
{
    [NSArchiver archiveRootObject:[self model] toFile:filename];
}

- (void)close:(id)sender
{
    [gameWindow performClose:sender];
}


@end


static int UNDO_MENU_CELL_TAG = 101;

@implementation GameGUI (OpenStepPatchUndoManagement)

- (void)undoChange:sender
{
    [[model undoManager] undo];
}

- (void)redoChange:sender
{
    [[model undoManager] redo];
}

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
    /*" Validate both the Undo and Redo menu cell. "*/
{
    BOOL result = YES;
/*    if ( [menuItem tag] == UNDO_MENU_CELL_TAG ) {
        result = [[model undoManager] canUndo];
    } else if ( [menuItem tag] == UNDO_MENU_CELL_TAG ) {
        result = [[model undoManager] canRedo];
    }
    [[model undoManager] updateMenuCells];
*/
    return result;
}

@end