/* CardGameProtocol.h created by veilljf on Fri 27-Nov-1998 */

#import "CardPileHolder.h"

/*---------------------------------------------------------------------------
|    CardGameProtocol
|
|    These methods may be implemented by a delegate of CardPileView
\---------------------------------------------------------------------------*/
@class CardPile;
@class CardImager;
@class CardPileHolder;

@interface CardPileHolder (CardGameProtocol)

- (void) clickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder;
- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder;
- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileHolder;
- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder;
- (void) acceptPile:(CardPile*)aCardPile in:(CardPileHolder*)aCardPileHolder;
- (void) removedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileHolder;

@end


@interface CardPileHolder(private)

- (void)resetLogicFlags;

@end

