/* CardGameProtocol.m created by veilljf on Tue 08-Dec-1998 */

#import "CardGameProtocol.h"

#define CS_CLICKED		(1 << 0)
#define CS_DRAGGED		(1 << 1)
#define CS_CANACCEPT	(1 << 2)
#define CS_ACCEPT		(1 << 3)
#define CS_REMOVED		(1 << 4)
// #define CS_GETOFFSET	(1 << 5)
#define CS_DOUBLECLICKED (1 << 6)
#define CS_MOUSEDOWN		(1 << 7)


@implementation CardPileHolder (CardGameProtocol)

/*"
This category implement the CardLogic (informal) protocol to the CardPileHolder.  That way, there is only one interface for card manipulation and logic.
"*/

- (void) clickedCard:(CardPile*)aCard in:(CardPileHolder*)cph
{
    if (logicFlags & CS_CLICKED) {
        [cardLogic clickedCard:aCard in:cph];
    }
}

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)cph
{
    if (logicFlags & CS_DOUBLECLICKED) {
        [cardLogic doubleClickedCard:aCard in:cph];
    }
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)cph
{
    if (logicFlags & CS_DRAGGED) {
        return [cardLogic draggedPile:aCardPile from:cph];
    }
    return NO;
}

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)cph
{
    if (logicFlags & CS_CANACCEPT) {
        return [cardLogic canAcceptPile:aCardPile from:sender in:cph];
    }
    return NO;
}

- (void) acceptPile:(CardPile*)aCardPile in:(CardPileHolder*)cph
{
    if (logicFlags & CS_ACCEPT) {
        [cardLogic acceptPile:aCardPile in:cph];
    }
}

- (void) removedPile:(CardPile*)aCardPile from:(CardPileHolder*)cph;
{
    if (logicFlags & CS_REMOVED) {
        [cardLogic removedPile:aCardPile from:cph];
    }
}

@end

@implementation CardPileHolder(private)

- (void)resetLogicFlags
    /*"
    Sets our delegate.  Every times we set the delegate, we reset our logicFlags.
     "*/
{
    logicFlags = 0;

    if (cardLogic)
    {
        logicFlags |= ([cardLogic respondsToSelector:@selector(clickedCard:in:)]) ? CS_CLICKED : 0;
        logicFlags |= ([cardLogic respondsToSelector:@selector(doubleClickedCard:in:)]) ? CS_DOUBLECLICKED : 0;
        logicFlags |= ([cardLogic respondsToSelector:@selector(draggedPile:from:)]) ? CS_DRAGGED : 0;
        logicFlags |= ([cardLogic respondsToSelector:@selector(canAcceptPile:from:in:)]) ? CS_CANACCEPT : 0;
        logicFlags |= ([cardLogic respondsToSelector:@selector(acceptPile:in:)]) ? CS_ACCEPT : 0;
        logicFlags |= ([cardLogic respondsToSelector:@selector(removedPile:from:)]) ? CS_REMOVED : 0;
    }
}

@end
