
#import "CardLogic.h"
#import "GameModel.h"


@implementation CardLogic

- gameModel
{
    return gameModel;
}

- (void)setGameModel:(GameModel*)gm
{
    // do not retain the gameModel to avoid retain cycles
    gameModel = gm;
//    if(gm != gameModel) {
//        [gameModel release];
//        gameModel = [gm retain];
//    }
}

- (void) acceptPile:(CardPile*)aCardPile in:(CardPileHolder*)aCardPileHolder
{
    [gameModel checkForWin];
}


- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
//    [super initWithCoder:aDecoder];
    gameModel = [[aDecoder decodeObject] retain];

    return self;
}
- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
//    [super encodeWithCoder:aCoder];
    [aCoder encodeObject:gameModel];
}


@end