/* CardPileHolder.m created by veilljf on Tue 17-Nov-1998 */

#import "CardPileHolder.h"
#import "CardPile.h"
#import <Foundation/Foundation.h>
#import "CardGameProtocol.h"

NSString *CARDHOLDER_INVALIDATE = @"Invalidate_Card_Holder";
NSString *CARDHOLDER_VALIDATE = @"Validate_Card_Holder";

@implementation CardPileHolder
/*" in the context of Solitaire, these method where added as categorie "*/

- initWithModel:mdl logic:lgc
{
    [self init];
    [self setGameModel:mdl];
    [self setCardLogic:lgc];
    return self;
}

- (void)dealloc
{
    [cardLogic release];
    [super dealloc];
}

- undoManager
{
    return [[self gameModel] undoManager];
}

- gameModel
{
    return gameModel;
}

- (void)setGameModel:gm
{
    // do not retain the gameModel to avoid retain cycles
    gameModel = gm;
//    if(gm != gameModel ) {
//        [gameModel release];
//        gameModel = [gm retain];   
//    }
}

- cardLogic
    /*" Return the card logic.  The cardLogic make sure that the card react properly. "*/
{
    return cardLogic;
}

- (void)setCardLogic:cl
    /*" Set the card logic.  The cardLogic make sure that the card react properly. "*/
{
    if(cl != cardLogic) {
        [cardLogic release];
        cardLogic = [cl retain];
        [self resetLogicFlags];
    }
}

- (int)numberOfContiniusHolderVisibleCard
    /*"end of a recursive algorithm. return 0;"*/
{
    return 0;
}

- firstHolderObject
    /*" return the top most holder. return self."*/
{
    return self;
}

- (void)flip
/*" end of a recursive algorithm. do nothing, "*/
{
    return;
}

- lastObject
/*" return the last object of the list"*/
{
    return [[self nextObject] lastObject];
}

- (void)dealLastObjectFaceDownTo:(ListHolder*)dest
    /*" move the last CardPile object from the list to the destination CardPile and set the faceUp to NO. "*/
{
    [self dealLastObjectTo:dest faceUp:NO];
}

- (void)dealLastObjectFaceUpTo:(ListHolder*)dest
    /*" move the last CardPile object from the list to the destination CardPile and set the faceUp to YES. "*/
{
    [self dealLastObjectTo:dest faceUp:YES];
}

- (void)dealLastObjectTo:(ListHolder*)dest faceUp:(BOOL)up
    /*" move the last CardPile object from the list to the destination CardPile and set the faceUp to 'up'. "*/
{
    [(CardPile*)[self lastObject] setFaceUp:up];
    [self dealLastObjectTo:dest];
}


/* this is a stateless state !
Subclass must implement how the state is keept.  Can be an instance variable and/or can be dependent of the state of the list itself.
*/

- (void)invalidate:sender
{
    [[NSNotificationCenter defaultCenter]
        postNotificationName:CARDHOLDER_INVALIDATE object:self];
    [self changed];
}

- (void)validate:sender
{
    [[NSNotificationCenter defaultCenter]
            postNotificationName:CARDHOLDER_VALIDATE object:self];
    [self changed];
}





- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
    [super initWithCoder:aDecoder];
    [self setCardLogic:[aDecoder decodeObject]];
    gameModel = [[aDecoder decodeObject] retain];

    return self;
}
- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
    [super encodeWithCoder:aCoder];
    [aCoder encodeObject:cardLogic];
    [aCoder encodeObject:gameModel];
}


@end
