/* CoveredCardPileView.m created by veilljf on Fri 20-Nov-1998 */

#import "CoveredListHolder.h"
#import "CardPileHolder.h"

@implementation CoveredListHolder

- (void) dealloc
/*"
        Frees our resources.
"*/
{
//    [coverPile1 release];
//    [coverPile2 release];
//    [coverPile3 release];
//    [coverPile4 release];
    [super dealloc];
}


- (void)setNextObject:(id)n
/*" By definition a CoveredListHolder that has no value is considered invalide. So if we set the nextObject to nil, we will invalidate ourself.  If we set the nextObject to something, then we will validate ourself. "*/
{
    [super setNextObject:n];
    if (n == nil) {
        [self invalidate:n];
    } else {
        [self validate:self];
    }
}

- (BOOL) pileCovered:sender
/*"
        Returns YES if any of the CardPileViews connected to coverPile1,
        coverPile2, coverPile3, or coverPile4 contain cards.  Returns NO if these
        id's are nil, or if the covering piles are empty.
"*/
{
    int 			coveringCards = 0;
    int 			count;
    ListHolder* 	covers[4] = {coverPile1, coverPile2, coverPile3, coverPile4};

    for (count = 0; count < 4; count++)
    {
        if (covers[count])
        {
            coveringCards += [covers[count] count];
        }
    }
    return (coveringCards > 0);
}


- (BOOL) pileCoveredBy:(ListHolder*)aCardPileView
/*"
        Returns YES if aCarePileView is non-empty (ie. contains cards) and covers
         this CardPileView (ie. is connected to coverPile1, coverPile2, coverPile3,
         or coverPile4).
"*/
{
    int coveringCards = 0;
    int count;
    id covers[4] = {coverPile1, coverPile2,
                    coverPile3, coverPile4};

    for (count = 0; count < 4; count++)
    {
        if (covers[count] == aCardPileView)
        {
            coveringCards += [covers[count] count];
            break;
        }
    }
    return (coveringCards > 0);
}


- (void) setCoverPile:(int)offset to:(CardPileHolder*)aPile
/*"
        Set the cover pile indicated by offset (which must be in the range 1 to 4)
        to aPile.
"*/
{
    switch (offset)
    {
    case 1:
        coverPile1 = aPile;
        break;
    case 2:
        coverPile2 = aPile;
        break;
    case 3:
        coverPile3 = aPile;
        break;
    case 4:
        coverPile4 = aPile;
        break;
    default:
        break;
    }
}

@end
