/* ListHolder_Card.m created by veilljf on Tue 17-Nov-1998 */

#import "ListHolder_Card.h"
#import "CardPile.h"
#import "NSUndoManager.h"

NSString *CARDHOLDER_INVALIDATE = @"Invalidate_Card_Holder";
NSString *CARDHOLDER_VALIDATE = @"Validate_Card_Holder";

@implementation ListHolder (Card)
/*" in the context of Solitaire, these method where added as categorie "*/

- (int)numberOfContiniusHolderVisibleCard
    /*"end of a recursive algorithm. return 0;"*/
{
    return 0;
}

- firstHolderObject
    /*" return the top most holder. return self."*/
{
    return self;
}

- (void)flip
/*" end of a recursive algorithm. do nothing, "*/
{
    return;
}

- lastObject
/*" return the last object of the list"*/
{
    return [[self nextObject] lastObject];
}

- (void)dealLastObjectFaceDownTo:(LinkList*)dest
    /*" move the last CardPile object from the list to the destination CardPile and set the faceUp to NO. "*/
{
    [self dealLastObjectTo:dest faceUp:NO];
}

- (void)dealLastObjectFaceUpTo:(LinkList*)dest
    /*" move the last CardPile object from the list to the destination CardPile and set the faceUp to YES. "*/
{
    [self dealLastObjectTo:dest faceUp:YES];
}

- (void)dealLastObjectTo:(LinkList*)dest faceUp:(BOOL)up
    /*" move the last CardPile object from the list to the destination CardPile and set the faceUp to 'up'. "*/
{
    [(CardPile*)[self lastObject] setFaceUp:up];
    [self dealLastObjectTo:dest];
}


/* this is a stateless state !
Subclass must implement how the state is keept.  Can be an instance variable and/or can be dependent of the state of the list itself.
*/

- (void)invalidate:sender
{
    [[NSNotificationCenter defaultCenter]
        postNotificationName:CARDHOLDER_INVALIDATE object:self];
    [self changed];
}

- (void)validate:sender
{
    [[NSNotificationCenter defaultCenter]
            postNotificationName:CARDHOLDER_VALIDATE object:self];
    [self changed];
}

@end
