/* DblLinkList.m created by veilljf on Mon 09-Nov-1998 */

#import "DblLinkList.h"

@implementation DblLinkList

/*" this is a basic double linked list."*/

- (void)addedAsNextObjectFrom:(ListHolder*)pr
/*"
    As a double linked list, we keep our holder as the previous node in the list.
    a three could implement this to keep track of all child it has.
 "*/
{
    [self setHolder:pr];
    [super addedAsNextObjectFrom:pr];
}

- (LinkList*)dealLastObject
    /*" return the last object, and remove it from the list. Adjust the holder

    WARNING / BUG :  WE ASSUME HERE THAT THE NEXT OBJECT IS ALSO A DOUBLELINKEDLIST.
"*/
{
    id result = self;
    if ([nextObject nextObject] == nil) {
        result = (nextObject == nil) ? self : nextObject;
        [result retain];
        [result autorelease];
        [[result holder] setNextObject:nil];
    } else {
        result = [nextObject dealLastObject];
    }
    return result;
}

- holder
    /*"return the holder of the current node."*/
{
    return holder;
}

- (void)setHolder:(id)h
    /*" Set the node's holder.  Does _NOT_ retain the holder. "*/
{
    if (h == self) {
        // this can append because of a design bug ! (shame on me, stupid coder)
        // this is to avoid circular references
        h = nil;
    }
    holder = h;
}

- (void)moveAtLastOf:(ListHolder*)list
    /*" Move the list at the end of the other list.  Adjust holder, and so on."*/
{
    id ho = [self holder];
    [super moveAtLastOf:list];
    [ho setNextObject:nil];
}

- (void)setHolderLink:(id)hder
    /*"Set the current node holder, also set the holder's nextObject to self."*/
{
    [holder setNextObject:nil]; // remove the old
    [self setHolder:hder];
    [hder setNextObject:self];
}

- (void)removeFromHolder
    /*"remove the current node from it's holder nextObject.  Basicaly set the hoder nextObject to nil. then set the current holder to nil.

    WARNING / BUG this could free self if no one else than the holder is retaining the node !"*/
{
    [self setHolderLink:nil];
}

- (int)absoluteIndexOfObjectValue:(id)crd
    /*" return the index from the bottom pile. "*/
{
    return [[self firstHolderObject] indexOfObjectValue:crd];
}

- firstHolderObject
    /*" return the first object if the list.  If the list is hold by a ListHolder, this method will in fact return the real first node next to the listholder, "*/
{
    id result;
    if(holder == nil) {
        result = self;
    } else {
        result = [holder firstHolderObject];
    }
    return result;
}

- (void)changed
    /*"Overide the changed notification so that the object to notify is the first object in the list.

    if we have a holder then will call changed to the holder,
    if (holder == nil) then will post the LINK_LIST_CHANGED notification "*/
{
    if([self holder] == nil) {
        [super changed];
    } else {
        [holder changed];
    }
}

- (id) initWithCoder:(NSCoder *)aDecoder
/*"
   Unarchives a link instance.
"*/
{
    [super initWithCoder:aDecoder];
    return self;
}


- (void) encodeWithCoder:(NSCoder *)aCoder
/*"
   Archives a link instance.
"*/
{
    [super encodeWithCoder:aCoder];
}


@end
