/* indent:4  tabsize:8  font:fixed-width */

#import "FTGameLogic.h"
#import "FTSuitLogic.h"
#import "FortyThievesModel.h"
#import <Solitaire/CardPile.h>
#import <Solitaire/CardPileHolder.h>

@implementation FTGameLogic

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int i;

    if (([aCard  count] == 1) && (![aCard isFaceUp]))
    {
        [aCard flip];
    }
    else if ([aCard count])
    {
        id *suitHlds = [(FortyThievesModel*)gameModel suitPileHolders];
        for (i=0; i<8; i++)
        {
            if ([suitHlds[i] canAcceptPile:aCard
                                      from:aCardPileHolder
                                        in:suitHlds[i]])
            {
                [aCard moveAtLastOf:suitHlds[i]];
                [gameModel checkForWin];
                break;
            }
        }
    }
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)lh
{
    // only move the top card
    if([aCardPile count] == 1)
    {
        return YES;
    }
    return NO;
}

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile* targetCard = [aCardPileHolder lastObject];

    if (targetCard)
    {
        if (([targetCard cardValue] == [aCardPile cardValue] + 1) &&
            ([targetCard cardSuit] == [aCardPile cardSuit]))
        {
            return YES;
        }
    }
    else
    {
        return YES;
    }
    return NO;
}

@end
