/* indent:4  tabsize:8  font:fixed-width */

#import "FTSuitLogic.h"
#import "FortyThievesModel.h"

#import <Solitaire/CardPile.h>
#import <Solitaire/CardPileHolder.h>

@implementation FTSuitLogic


- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile*   targetCard = [aCardPileHolder lastObject];
    
    if (targetCard)
    {
        if (([aCardPile cardSuit] == [targetCard cardSuit]) &&
            ([aCardPile cardValue] == [targetCard cardValue] + 1))
        {
            return YES;
        }
    }
    else
    {
        if ([aCardPile cardValue] == CS_ACE)
        {
            return YES;
        }
    }
    return NO;
}

@end

