/* indent:4  tabsize:8  font:fixed-width */

#import "FreezeLGameLogic.h"
#import "FreezeLModel.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation FreezeLGameLogic

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int i;
    CardPile* cardPile = [aCardPileHolder nextObject];
    CardPileHolder** tempHlds = [[self gameModel] tempPileHolders];
    if (aCard == [cardPile lastObject])
    {
        for (i = 0; i < 4; i++)
        {
            if ([tempHlds[i] canAcceptPile:cardPile
                                      from:aCardPileHolder
                                        in:tempHlds[i]])
            {
                [cardPile dealLastObjectTo:tempHlds[i]];
                [[self gameModel] moveSuitableCards];
                break;
            }
        }
    } 
}


- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileView
{
    if ([aCardPile isAllNextFaceUp])
    {
	/* Can only drag if all cards above are alternating color and in
	   descending sequence */
        if(([aCardPile isAllNextInDecreasingCardValue] && [aCardPile isAllNextInAlternateColor]) == YES)
        {
            return YES;
        }
    }
    return NO;
}


- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile* targetCard = [aCardPileHolder lastObject];

    if (targetCard)
    {
        if (([targetCard isFaceUp]) &&
            ([targetCard cardColor] != [aCardPile cardColor]) &&
            ([targetCard cardValue] == [aCardPile cardValue] + 1))
        {
            return YES;
        }
    }
    else
    {
        return YES;
    }
    
    return NO;
}

- (void) acceptPile:(CardPile*)aCardPile in:(CardPileHolder*)aCardPileHolder
{
    [[self gameModel] moveSuitableCards];
}

- (void)removedPile:(CardPile *)aCardPile from:(CardPileHolder *)aCardPileView
{
    [[self gameModel] moveSuitableCards];

}
@end

