/* indent:4  tabsize:8  font:fixed-width */

#import "FreezeLModel.h"
#import "localstrings.h"
#import "FreezeLTempLogic.h"
#import "FreezeLSuitLogic.h"
#import "FreezeLGameLogic.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation FreezeLModel

- init
{
    int i = 0;
    // create logic objects
    id gamePileLogic;
    id suitPileLogic;
    id tempPileLogic;
    [super init];
    gamePileLogic = [[FreezeLGameLogic alloc] init];
    suitPileLogic = [[FreezeLSuitLogic alloc] init];
    tempPileLogic = [[FreezeLTempLogic alloc] init];

    [gamePileLogic setGameModel:self];
    [suitPileLogic setGameModel:self];
    [tempPileLogic setGameModel:self];

    // then create the gamePileHolders
    for(i = 0 ; i < 8 ; i++ ) {
        gamePileHolders[i] = [[CardPileHolder alloc] init];
        [gamePileHolders[i] setCardLogic:gamePileLogic];
        [gamePileHolders[i] setGameModel:self];
    }
    // then create the suitPileHolders
    for(i = 0 ; i < 4 ; i++ ) {
        suitPileHolders[i] = [[CardPileHolder alloc] init];
        [suitPileHolders[i] setCardLogic:suitPileLogic];
        [suitPileHolders[i] setGameModel:self];
    }

    // then create the suitPileHolders
    for(i = 0 ; i < 4 ; i++ ) {
        tempPileHolders[i] = [[CardPileHolder alloc] init];
        [tempPileHolders[i] setCardLogic:tempPileLogic];
        [tempPileHolders[i] setGameModel:self];
    }

    [self newGame];

    [gamePileLogic release];
    [suitPileLogic release];
    [tempPileLogic release];

    return self;
}

- (void)dealloc
{
    int i = 0;
    for(i = 0; i < 4 ; i++ ) {
        [suitPileHolders[i] release];
        [tempPileHolders[i] release];
    }
    for(i = 0; i < 8 ; i++ ) {
        [gamePileHolders[i] release];
    }
    [super dealloc];
}

- (CardPileHolder**)gamePileHolders
{
    return gamePileHolders;
}

- (CardPileHolder**)suitPileHolders
{
    return suitPileHolders;
}

- (CardPileHolder**)tempPileHolders
{
    return tempPileHolders;
}

- (void)setupGameUsingDeal:(CardPile*)deal
    /*" Setup a new using this specified Deal. "*/
{
    int		pileIndex, cycle;

    //-----------------------------------------------------------------------
    //    Initialize the "suit piles" and "temp piles" as empty
    //-----------------------------------------------------------------------

    for (pileIndex = 0; pileIndex < 4; pileIndex++)
    {
        [suitPileHolders[pileIndex] empty];
        [tempPileHolders[pileIndex] empty];
    }

    //-----------------------------------------------------------------------
    //    Initialize and deal cards to the 8 "user piles"
    //-----------------------------------------------------------------------

    for (pileIndex = 0; pileIndex < 8; pileIndex++)
    {
        [gamePileHolders[pileIndex] empty];
    }

    for (cycle = 0; cycle < 6; cycle++)
      {
        for (pileIndex = 0; pileIndex < 8; pileIndex++)
          {
            [deal dealLastObjectFaceUpTo:gamePileHolders[pileIndex]];
          }
      }

    for (pileIndex = 0; pileIndex < 4; pileIndex++)
    {
        [deal dealLastObjectFaceUpTo:gamePileHolders[pileIndex]];
    }

    [super setupGameUsingDeal:deal];

    [self moveSuitableCards];
}

- (void) checkForWin
    /*" Called to check the state of the game. "*/
{
    if ([suitPileHolders[1]  count] +
        [suitPileHolders[2]  count] +
        [suitPileHolders[3]  count] +
        [suitPileHolders[4]  count] == 52)
    {
        [self win];
    }
}

- (void)moveSuitableCards
{
    while ([self searchForCardInCardPileHolders:gamePileHolders length:8]
           || [self searchForCardInCardPileHolders:tempPileHolders length:4]) {
    }

    [self checkForWin];
}

- (BOOL)searchForCardInCardPileHolders:(CardPileHolder **)cardHlds
                                length:(int)len
{
    int i, j, k;

    for (i = 0; i < len; i++) {
        CardPile *t = [cardHlds[i] lastObject];
        if (t) {
            for (j = 0; j < 4; j++) {
                CardPile *s = [suitPileHolders[j] lastObject];
                if ((s == nil && [t cardValue] == CS_ACE)
                    || (s != nil && [t cardSuit] == [s cardSuit] && [t cardValue] == [s cardValue] + 1)) {
                    // it's legal to move t to this suit pile, now see if it's desirable
                    if ([t cardValue] > CS_TWO) {
                        int points = 0;

                        for (k = 0; k < 4; k++) {
                            CardPile *p = [suitPileHolders[k] lastObject];
                            if (p != nil && ([p cardColor] != [t cardColor])
                                && ((int)([t cardValue] - [p cardValue]) <= 2)) {
                                points++;
                            }
                        }

                        if (points < 2)
                            break;
                    }

                    // do the move
                    [t moveAtLastOf:suitPileHolders[j]];
                    return YES;
                }
            }
        }
    }
    return NO;
}
    
- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
    int i = 0;
    [super initWithCoder:aDecoder];

    for(i = 0 ; i< 4 ; i++) {
        suitPileHolders[i] = [[aDecoder decodeObject] retain];
        tempPileHolders[i] = [[aDecoder decodeObject] retain];
    }
    for(i = 0 ; i < 8 ; i++) {
        gamePileHolders[i] = [[aDecoder decodeObject] retain];
    }

    return self;
}

- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
    int i = 0;
    [super encodeWithCoder:aCoder];

    for(i = 0 ; i< 4 ; i++) {
        [aCoder encodeObject:suitPileHolders[i]];
        [aCoder encodeObject:tempPileHolders[i]];
    }

    for(i=0 ; i < 8 ; i++ ) {
        [aCoder encodeObject:gamePileHolders[i]];
    }
}

@end