/* indent:4  tabsize:8  font:fixed-width */

#import "KlondikeDiscardLogic.h"
#import "KlondikeSuitLogic.h"
#import "KlondikeModel.h"
#import <Solitaire/CardPile.h>
#import <Solitaire/CardImager.h>
#import <Solitaire/CardPileHolder.h>

@implementation KlondikeDiscardLogic

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int 		i;

    if (([aCard count] == 1 ) && (![aCard isFaceUp]))
    {
        [aCard flip];
    }
    else if ([aCard count] == 1 )
    {
        CardPileHolder** suitHlds = [[self gameModel] suitPileHolders];
        for (i=0;i<4;i++) {
            if ([suitHlds[i] canAcceptPile:aCard
                                    from:aCardPileHolder
                                      in:suitHlds[i]]) {
                [aCardPileHolder dealLastObjectTo:suitHlds[i]];
                [[self gameModel] checkForWin];
                break;
            }
        }
    } 
}


- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileHolder
{
    if ([aCardPile count] == 1) {
        return YES;
    }
    return NO;
}

@end
