/* indent:4  tabsize:8  font:fixed-width */

#import "KlondikeGUI.h"
#import "KlondikeModel.h"
#import "localstrings.h"
#import "KlondikePrefs.h"

@implementation KlondikeGUI

- (void)setupGame
{
    int 		i;
    CardPileView*  	suitCardPiles[4];
    CardPileView*  	gameCardPiles[7];
    CardPileHolder**    suitHlds = [model suitPileHolders];
    CardPileHolder**    gameHlds = [model gamePileHolders];


    [gameWindow disableFlushWindow];

    suitCardPiles[0] = suitPileView1;
    suitCardPiles[1] = suitPileView2;
    suitCardPiles[2] = suitPileView3;
    suitCardPiles[3] = suitPileView4;
    for (i = 0; i < 4; i++)
    {
        [suitCardPiles[i] setModel: suitHlds[i]];
    }
    
    gameCardPiles[0] = gamePileView1;
    gameCardPiles[1] = gamePileView2;
    gameCardPiles[2] = gamePileView3;
    gameCardPiles[3] = gamePileView4;
    gameCardPiles[4] = gamePileView5;
    gameCardPiles[5] = gamePileView6;
    gameCardPiles[6] = gamePileView7;
    for (i = 0; i < 7; i++)
    {
        [gameCardPiles[i] setModel:gameHlds[i]];
        [gameCardPiles[i] setOffset:0.0 :[[gameCardPiles[i] cardImager] yTopSpace]];
    }

    [drawPileView setModel:[model drawPileHolder]];
    [discardPileView setModel:[model discardPileHolder]];
    [discardPileView setMaxVisibleCards:[model dealMaxNumber]];
    if ([model dealMaxNumber] == 1)
        [discardPileView setOffset:[[discardPileView cardImager] xStackSpace] :0.0];
    else
        [discardPileView setOffset:[[discardPileView cardImager] xTopSpace] :0.0];

    [gameWindow display];
    [gameWindow enableFlushWindow];
    [gameWindow flushWindow];

    [gameWindow makeKeyAndOrderFront:self]; 
}

@end

