/* indent:4  tabsize:8  font:fixed-width */

#import "KlondikeModel.h"
#import "localstrings.h"
#import "KlondikeDrawLogic.h"
#import "KlondikeGameLogic.h"
#import "KlondikeSuitLogic.h"
#import "KlondikeDiscardLogic.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation KlondikeModel

- (CardPileHolder**)suitPileHolders
{
    return suitPileHolders;
}

- (CardPileHolder**)gamePileHolders
{
    return gamePileHolders;
}

- (CardPileHolder*)discardPileHolder
{
    return discardPileHolder;
}

- (CardPileHolder*)drawPileHolder
{
    return drawPileHolder;
}

- (int)dealMaxNumber
{
    return dealMaxNumber;
}

- init
{
    int  i;

    id suitLogic = [[KlondikeSuitLogic alloc] init];
    id gameLogic = [[KlondikeGameLogic alloc] init];
    id discardLogic = [[KlondikeDiscardLogic alloc] init];
    id drawLogic = [[KlondikeDrawLogic alloc] init];

    [super init];
    [suitLogic setGameModel:self];
    [gameLogic setGameModel:self];
    [discardLogic setGameModel:self];
    [drawLogic setGameModel:self];

    for(i = 0 ; i < 7 ; i++ ) {
        gamePileHolders[i] = [[CardPileHolder alloc] initWithModel:self logic:gameLogic];
    }

    drawPileHolder = [[CardPileHolder alloc] initWithModel:self logic:drawLogic];
    discardPileHolder = [[CardPileHolder alloc] initWithModel:self logic:discardLogic];

    for(i = 0 ; i < 4 ; i++ ) {
        suitPileHolders[i] = [[CardPileHolder alloc] initWithModel:self logic:suitLogic];
    }

    dealMaxNumber = [[NSUserDefaults standardUserDefaults] integerForKey:@"CardsToDraw"];

    [self newGame];

    [suitLogic release];
    [gameLogic release];
    [drawLogic release];
    [discardLogic release];

    return self;
}

- (void)dealloc
{
    int i = 0;
    [drawPileHolder release];
    [discardPileHolder release];
    for(i = 0; i < 4 ; i++ ) {
        [suitPileHolders[i] release];
    }
    for(i = 0; i < 7 ; i++ ) {
        [gamePileHolders[i] release];
    }
    [super dealloc];
}

- (void)setupGameUsingDeal:(CardPile*)deal
    /*"    Setup a new game.  If "redeal" is true, deal a new deck, otherwise
    use the same cards as the previous game. "*/
{
    int pileIndex, i;
    [drawPileHolder empty];
    [discardPileHolder empty];
    [drawPileHolder setNextObject:deal];
    for ( pileIndex = 0 ; pileIndex < 4 ; pileIndex++ )
    {
        [suitPileHolders[pileIndex] empty];
    }
    //-----------------------------------------------------------------------
    //    Initialize and deal cards to the seven "user piles"
    //-----------------------------------------------------------------------
    for (pileIndex = 0; pileIndex < 7; pileIndex++)
    {
        [gamePileHolders[pileIndex] empty];

        for (i = 0; i <= pileIndex; i++)
        {
            [deal dealLastObjectTo:gamePileHolders[pileIndex]];
        }    
        [[gamePileHolders[pileIndex] lastObject] flip];
    }
    [super setupGameUsingDeal:deal];
}

- (BOOL)isWinning
    /*"   Called to check the state of the game. "*/
{
    int cnt = 0;
    int i;
    for( i = 0 ; i < 4 ; i++ ) {
        cnt += [suitPileHolders[i] count];
    }
    return ( cnt == 52 );
}

- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
    int i = 0;
    [super initWithCoder:aDecoder];

    for(i = 0 ; i< 7 ; i++) {
        gamePileHolders[i] = [[aDecoder decodeObject] retain];
    }
    for(i = 0 ; i < 4 ; i++) {
        suitPileHolders[i] = [[aDecoder decodeObject] retain];
    }
    drawPileHolder = [[aDecoder decodeObject] retain];
    discardPileHolder = [[aDecoder decodeObject] retain];
    [aDecoder decodeValueOfObjCType:@encode(unsigned int) at:&dealMaxNumber];
    return self;
}

- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
    int i = 0;
    [super encodeWithCoder:aCoder];

    for(i = 0 ; i< 7 ; i++) {
        [aCoder encodeObject:gamePileHolders[i]];
    }
    for(i=0 ; i < 4 ; i++ ) {
        [aCoder encodeObject:suitPileHolders[i]];
    }
    [aCoder encodeObject:drawPileHolder];
    [aCoder encodeObject:discardPileHolder];
    [aCoder encodeValueOfObjCType:@encode(unsigned int) at:&dealMaxNumber];
}

@end

