/* indent:4  tabsize:8  font:fixed-width */


#import "KlondikeSuitLogic.h"
#import "KlondikeModel.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>
#import <Solitaire/Card.h>

@implementation KlondikeSuitLogic

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile*   droppingCard = aCardPile;
    CardPile*   targetCard = [aCardPileHolder lastObject];

    if (targetCard)
    {
        if (([aCardPile cardSuit] == [targetCard cardSuit]) &&
            ([aCardPile cardValue] == [targetCard cardValue] + 1))
        {
            return YES;
        }
    }
    else
    {
        if ([droppingCard cardValue] == CS_ACE)
        {
            return YES;
        }
    }
    return NO;
}

- (void) acceptPile:(CardPile*)aCardPile in:(ListHolder*)aCardPileHolder
{
    [[self gameModel] checkForWin];
}

@end
