/* indent:4  tabsize:8  font:fixed-width */

#import "PyramidDiscardLogic.h"
#import <Solitaire/CardPile.h>
#import <Solitaire/CardPileHolder.h>

@implementation PyramidDiscardLogic

/*-------------------------------------------------------------------------
|
|    - (BOOL)canAcceptPile:aCardPile from:sender in:discardCardPileView
|
|    returns:	(BOOL)	YES if this pile will accept the cards dropped on it
|
|		(BOOL)	NO if this pile will not accept the dropped cards
|
|--------------------------------------------------------------------------
|
|	Called by a DiscardCardPileView when a card pile wants to be dropped 
|	on this it.
|	
\-------------------------------------------------------------------------*/

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)discardCardPileView
{
    /*---------------------------------------------------------------------
     *
     * Only Kings may be dropped directly on the match piles.
     *
     *--------------------------------------------------------------------*/
    
    if ([[aCardPile lastObject] cardValue] == CS_KING)
    {
        return YES;
    }
    return NO;
}

@end
