/* indent:4  tabsize:8  font:fixed-width */

#import "PyramidModel.h"
#import "PyramidDiscardLogic.h"
#import "PyramidGameLogic.h"
#import "PyramidStockLogic.h"
#import "PyramidWasteLogic.h"
#import "PyramidPrefs.h"
#import "localstrings.h"
#import <Solitaire/CoveredListHolder.h>
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation PyramidModel

- (void)setupCoveredCardHolderRelationship
    /*" This is not very good, but I have nothing better for the
    current framework where the View define everything.
    "*/
{
    int i = 0;
    int cntr = 1;
    int times = 0;
    for(i = 0; i < 20 ; i ++ ) {
        id c = gamePileHolders[i];
        int leftIdx = i + cntr;
        [c setCoverPile:1 to:gamePileHolders[leftIdx]];
        [c setCoverPile:2 to:gamePileHolders[leftIdx+1]];
        times ++;
        if(times == cntr) {
            times = 0;
            cntr++;
        }
    }
}

- init
{
    int		i;
    id stockLogic = [[PyramidStockLogic alloc] init];
    id gameLogic = [[PyramidGameLogic alloc] init];
    id wasteLogic = [[PyramidWasteLogic alloc] init];
    id discardLogic = [[PyramidDiscardLogic alloc] init];

    [super init];

    [self setDealCount:1];
    pyramidEmpty = NO;

    [stockLogic setGameModel:self];
    [gameLogic setGameModel:self];
    [wasteLogic setGameModel:self];
    [discardLogic setGameModel:self];

    for( i=0 ; i < 28 ; i++ ) {
        gamePileHolders[i] = [[CoveredListHolder alloc] initWithModel:self logic:gameLogic];
    }

    wastePileHolder = [[CardPileHolder alloc] initWithModel:self logic:wasteLogic];
    discardPileHolders[0] = [[CardPileHolder alloc] initWithModel:self logic:discardLogic];
    discardPileHolders[1] = [[CardPileHolder alloc] initWithModel:self logic:discardLogic];
    stockPileHolder = [[CardPileHolder alloc] initWithModel:self logic:stockLogic];

    [self setupCoveredCardHolderRelationship];

    [self newGame];

    [stockLogic release];
    [gameLogic release];
    [wasteLogic release];
    [discardLogic release];

    return self;
}

- (void)dealloc
{
    int i = 0;
    [stockPileHolder release];
    [wastePileHolder release];
    for(i = 0; i < 28 ; i++ ) {
        [gamePileHolders[i] release];
    }
    for(i = 0; i < 2 ; i++ ) {
        [discardPileHolders[i] release];
    }
    [super dealloc];
}

- (void)setupGameUsingDeal:(CardPile*)deal
{
    int i;

    [stockPileHolder setNextObject:deal];
    // Initialize and deal cards to the 28 "game piles"
    for (i = 0; i < 28; i++)
    {
        ListHolder* 	userPile;
        //   Deal the cards.
        userPile = gamePileHolders[i];
	[userPile empty];
        [stockPileHolder dealLastObjectFaceUpTo:userPile];
    }
    [super setupGameUsingDeal:deal];    
}

- (CardPileHolder*)wastePileHolder
{
    return wastePileHolder;
}

- (CardPileHolder*)stockPileHolder
{
    return stockPileHolder;
}

- (CardPileHolder**)discardPileHolders
{
    return discardPileHolders;
}

- (CardPileHolder**)gamePileHolders
{
    return gamePileHolders;
}

- (void) endGame:sender
    /*"  End the game in progress.  Discard the game window.  "*/
{
    if (gameInProgress) 
    {
        [self determineScore];
        gameInProgress = NO;
    }

    // close the game window
    [super endGame:sender];
}

- (void) win
/*"
    Called when the game has been won.  This is where you can insert fancy
    winning routines, or just call the default (boring) routine.
"*/
{
#warning what about preferences and score ?!
//    int score =  [(PyramidPrefs*)prefs pyramidScore];
    int score = 100;
    NSRunAlertPanel(@"You're finished", @"Congratulations, your new score is %d",
                    @"Yeah!", nil, nil, score);
    [super win];
}

- (BOOL)isWinning
/*"    Called to check the state of the game.  Always override (unless your
    game is impossible to win).  This is ugly because it handles winning
    and keeping track of the score.
"*/
{
#warning VERY NASTY  ...  VERY !!!  I simply commented it all to make it worse.
/*
    int i, j;
    int total;
    BOOL didMatch;
    //   Points for clearing the pyramid...
    // should be replace by something similar to :
    // if (![TopPyramidHolder isValid]) { THEN WE WIN ! }
    // else numberOfCardLeft = [TopPyramidHolder countValidDependents]
    for (j = 0, didMatch = NO; j < total && !pyramidEmpty && !didMatch; j++)
    {
        CardPileView* theView = [viewList objectAtIndex:j];
	
        for (i = 0; i < 28 && !didMatch; i++)
	{
	    if (theView == gameCardPiles[i]) 
	        didMatch = YES;
	}
    }
    if (!didMatch && !pyramidEmpty)
    {
        int bonus = 50 - (([self dealCount] -1) * 15); // 50 - 35 - 20
            [(PyramidPrefs*)prefs setPyramidScore:[(PyramidPrefs*)prefs pyramidScore] + bonus];
            pyramidEmpty = YES;
    }
*/

    /*-----------------------------------------------------------------------
     *    Cleared everything; you win.
     *---------------------------------------------------------------------*/
/*    if ([[discardCardPileViewL cardHolder] count] +
        [[discardCardPileViewR cardHolder] count] == 52)
    {
        [self win];
	gameInProgress = NO;
    }
*/    
    /*-----------------------------------------------------------------------
     *
     *    If the stock pile is empty and we have used both redeals AND the
     *    pyramid is empty, then it's time to count the remaining cards.
     *
     *---------------------------------------------------------------------*/
/*    if (pyramidEmpty && [[stockCardPileView cardHolder] count] == 0 &&
            [self dealCount] == 3)
    {
        [self determineScore];
	[self win];
        gameInProgress = NO;
    }
    
    gameInProgress = YES;
*/
    return NO;
}

- (int) dealCount
    /*"   The deal count is incremented everytime the deck is flipped.  "*/
{
    return dealCount;
}

- (void) setDealCount:(int)count
    /*"  Set the deal count.  This is the number of passes through the stock.  "*/
{
    dealCount = count; 
}

- (void) incDealCount
    /*" Add one to the deal count. "*/
{
    dealCount++; 
}

- (void) startGame:sender
    /*"    Start a new game.  Get confirmation from the user before aborting a game in progress."*/
{
#warning TODO: clean this up ... is this method called ? verify the interaction
    if (gameInProgress) [self determineScore];
    [super startGame:sender];
}

- (void) restartGame:sender
    /*" Restart the game in progress."*/
{
#warning TODO: clean this up ... is this method called ? verify the interaction
    if (gameInProgress) [self determineScore];
    [super restartGame:sender];
}

- (void) determineScore
    /*" Subtract the remaining cards from the current score. "*/
{
    int total = 52;
    total -= [discardPileHolders[0] count];
    total -= [discardPileHolders[1] count];
#warning what about preferences and scores !?
//    [(PyramidPrefs*)prefs setPyramidScore:[(PyramidPrefs*)prefs pyramidScore] - total]; 
}

- (id) initWithCoder:(NSCoder *)aDecoder
    /*"
    Unarchives a GameModel instance. archive the state of all pileHolders
     "*/
{
    int i = 0;
    [super initWithCoder:aDecoder];

    for(i = 0 ; i < 28 ; i++) {
        gamePileHolders[i] = [[aDecoder decodeObject] retain];
    }
    for(i = 0 ; i < 2 ; i++) {
        discardPileHolders[i] = [[aDecoder decodeObject] retain];
    }
    stockPileHolder = [[aDecoder decodeObject] retain];
    wastePileHolder = [[aDecoder decodeObject] retain];
    [aDecoder decodeValueOfObjCType:@encode(unsigned int) at:&dealCount];
    [aDecoder decodeValueOfObjCType:@encode(BOOL) at:&gameInProgress];
    [aDecoder decodeValueOfObjCType:@encode(BOOL) at:&pyramidEmpty];
    return self;
}

- (void) encodeWithCoder:(NSCoder *)aCoder
    /*"
    Archives a GameModel instance.  Unarchive the state of all pileHolders
     "*/
{
    int i = 0;
    [super encodeWithCoder:aCoder];

    for(i = 0 ; i < 28 ; i++) {
        [aCoder encodeObject:gamePileHolders[i]];
    }
    for(i = 0 ; i < 2 ; i++ ) {
        [aCoder encodeObject:discardPileHolders[i]];
    }
    [aCoder encodeObject:stockPileHolder];
    [aCoder encodeObject:wastePileHolder];
    [aCoder encodeValueOfObjCType:@encode(unsigned int) at:&dealCount];
    [aCoder encodeValueOfObjCType:@encode(BOOL) at:&gameInProgress];
    [aCoder encodeValueOfObjCType:@encode(BOOL) at:&pyramidEmpty];
}

@end
