/* indent:4  tabsize:8  font:fixed-width */


#import "PyramidStockLogic.h"
#import "PyramidModel.h"
#import "localstrings.h"
#import <Solitaire/CardPile.h>

#import <AppKit/NSApplication.h>
#import <AppKit/NSPanel.h>

@implementation PyramidStockLogic

- (void) clickedCard:(CardPile*)aCard in:(ListHolder*)stockCardHolder
    /*"	Called by the StockPileCardView when the mouse is clicked on the pile."*/
{
    /*-----------------------------------------------------------------------
    |	If the stock pile is empty, turn over the waste pile
    |	and move the cards pack to the stock pile.
    \-----------------------------------------------------------------------*/
    id wasteCardHolder = [(PyramidModel*)gameModel wastePileHolder];

    if (!aCard)
    {
	/*-----------------------------------------------------------------
        |	The pile may not actually be empty; the user may
        |	have clicked on an exposed area of the pile view.
        \----------------------------------------------------------------*/

        if ([stockCardHolder count] > 0)
	{
	    return;
	}
        if ([(PyramidModel*)gameModel dealCount] < 3)
	{
            int idx = [wasteCardHolder count];
            int i;
            for(i = 0; i < idx ; i++) {
                [wasteCardHolder dealLastObjectFaceDownTo:stockCardHolder];
            }
            [(PyramidModel*)gameModel incDealCount];
	}
	else
	{
#warning DESIGN BUG: This Panel create a dependencies with the AppKit, while in a card logic object
            NSRunAlertPanel(LOCALIZED_GAME_NAME, LOCALIZED_NO_FLIP, @"", nil, nil);
	    return;
    }
    } else

    /*-----------------------------------------------------------------
    |	If the top card was clicked, and it was face-down,
    |	turn it face-up.  Then, move it to the waste pile.
    |	If this card and the card currently on top of the waste
    |	pile add to 13, give the user the option to leave it on
    |	the waste pile, or to discard them both.
    \---------------------------------------------------------------*/

        if ((aCard == [stockCardHolder lastObject]) && (![aCard isFaceUp]))
    {
        CardPile* wasteCard = [wasteCardHolder lastObject];

	[aCard flip];

	if (wasteCard && ([aCard cardValue] + [wasteCard cardValue] == 11))
	{
	    int result;
	    
//	    [[alertPanel first] setTitle:LOCALIZED_LEAVE_ON_WASTE];
//	    [[alertPanel second] setTitle:LOCALIZED_REMOVE_THEM];
//	    [[alertPanel message] setStringValue:LOCALIZED_TURN_MATCH];
//	    [[alertPanel alert] setStringValue:LOCALIZED_GAME_NAME];
//	    [alertPanel run:self];
//	    result = [alertPanel lastResult];
            result = 0;
#warning TODO : this is a workaround just to make it work !  Actualy there is no framework for user interaction without AppKit dependencies.
//	    if (result == NSAlertAlternateReturn)
            if (result == 0)
	    {
                id *disHlds = [(PyramidModel*)gameModel discardPileHolders];
                [stockCardHolder dealLastObjectTo:disHlds[0]];
                [wasteCardHolder dealLastObjectTo:disHlds[1]];
                [gameModel checkForWin];
		return;
	    }
	}
        [stockCardHolder dealLastObjectTo:wasteCardHolder];
        [gameModel checkForWin];
    } 
}

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(ListHolder*)stockCardHolder
    /*"	Called by the StockPileCardView when a card pile wants to be dropped on this pile. "*/
{
    return NO;
}

@end

