/* indent:4  tabsize:8  font:fixed-width */


#import "PyramidWasteLogic.h"
#import <Solitaire/CardPile.h>
#import <Solitaire/CardPileHolder.h>
#import "PyramidModel.h"

@implementation PyramidWasteLogic

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(ListHolder*)wasteCardPileHolder
    /*"	If the card being dropped and the card on top of the
            pile add to thirteen, allow the card to be dropped.
            Both cards will be moved to the discardCardPiles in
            the acceptPile delegate method. "*/
{
    CardPile* card1 = [aCardPile lastObject];
    CardPile* card2 = [[(PyramidModel*)gameModel wastePileHolder] lastObject];

    if (card1 && card2 && ([card1 cardValue] + [card2 cardValue] == 11))
    {
        return YES;
    }
    else
    {
        return NO;
    }
}

- (void) acceptPile:(CardPile*)aCardPile in:(ListHolder*)wasteCardPileHolder
/*"	Called by WasteCardHolder after cards have been successfully
    added to the pile as a result of cards being dropped on it.
"*/
{
    CardPileHolder* 	pile = [(PyramidModel*)gameModel wastePileHolder];
    id* 	disHlds = [(PyramidModel*)gameModel discardPileHolders];
    [pile dealLastObjectFaceUpTo:disHlds[0]];
    [pile dealLastObjectFaceUpTo:disHlds[1]];
    [gameModel checkForWin]; 
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(ListHolder*)wasteCardHolder
{
    return YES;
}

- (void) doubleClickedCard:(CardPile*)aCard in:(ListHolder*)aCardPileHolder
    /*" Double clicked on a card; discard if it is a King."*/
{
    ListHolder* cardPile = aCardPileHolder;
    
    if (aCard && (aCard == [cardPile lastObject]) && [aCard cardValue] == CS_KING)
    {
        id* 	disHlds = [(PyramidModel*)gameModel discardPileHolders];
        [cardPile dealLastObjectTo: disHlds[0]];
        [gameModel checkForWin];
    } 
}

@end

