
#import "SpiderDrawLogic.h"
#import "SpiderModel.h"
#import <Solitaire/CardSet.h>
#import "localstrings.h"


@implementation SpiderDrawLogic

- (void) clickedCard:(CardPile*)aCard in:(CardPileHolder*)drawCardPileHolder
/*" Deal one card to our game piles.  Do nothing if one of the game piles is empty but show a panel saying so. "*/
{
    int   		i;
    int   		numSpaces;
    int   		numCards;
    CardPileHolder**	gameCardPiles;

    gameCardPiles = [[self gameModel] gamePileHolders];

    if (aCard)
    {
        numSpaces = 0;
	for (i = 0; i < 10; i++)
	{
	    if ([gameCardPiles[i] count] == 0) numSpaces++;
	}
	
	if (numSpaces > 0)
	{
	    numCards = 0;
	    for (i = 0; i < 10; i++)
	    {
                numCards += [gameCardPiles[i] count];
	    }
	    
	    if (numCards >= 10)
	    {
#warning DESIGN BUG: This Panel create a dependencies with the AppKit, while in a card logic object
                NSRunAlertPanel(LOCALIZED_GAME_NAME, LOCALIZED_FILL_SPACES, @"", nil, nil);
	        return;
	    }
	}
	for (i = 0; i < 10; i++)
	{
            [drawCardPileHolder dealLastObjectFaceUpTo:gameCardPiles[i]];
	}
    } 
}

@end

