/* indent:4  tabsize:8  font:fixed-width */

#import "SpiderGUI.h"
#import "SpiderModel.h"
#import "localstrings.h"
#import "SpiderDrawLogic.h"
#import "SpiderSuitLogic.h"
#import "SpiderGameLogic.h"
#import <Solitaire/CardPileView.h>
#import <Solitaire/CardImager.h>

@implementation SpiderGUI

- (void)setupGame
    /*" Setup the game using this specified Deal.
    This method will reset view, etc. "*/
{
    int 		i;
    CardPileView*  	suitViews[8];
    CardPileView*  	gameViews[10];
    CardPileHolder**	suitHolders = [model suitPileHolders];
    CardPileHolder**	gameHolders = [model gamePileHolders];

    [gameWindow disableFlushWindow];

    //----------------------------------------------------------------
    //    Sync pile id's with current game window and set
    //    preferences and delegates
    //----------------------------------------------------------------

    suitViews[0] = suitPileView1;
    suitViews[1] = suitPileView2;
    suitViews[2] = suitPileView3;
    suitViews[3] = suitPileView4;
    suitViews[4] = suitPileView5;
    suitViews[5] = suitPileView6;
    suitViews[6] = suitPileView7;
    suitViews[7] = suitPileView8;

    for (i = 0; i < 8; i++)
    {
        [suitViews[i] setModel:suitHolders[i]];
    }

    gameViews[0] = gamePileView1;
    gameViews[1] = gamePileView2;
    gameViews[2] = gamePileView3;
    gameViews[3] = gamePileView4;
    gameViews[4] = gamePileView5;
    gameViews[5] = gamePileView6;
    gameViews[6] = gamePileView7;
    gameViews[7] = gamePileView8;
    gameViews[8] = gamePileView9;
    gameViews[9] = gamePileView10;
    for (i = 0; i < 10; i++)
    {
        [gameViews[i] setModel:gameHolders[i]];
        [gameViews[i] setOffset:0.0 :[[gameViews[i] cardImager] yTopSpace]];
    }

    [drawPileView setModel:[model drawPileHolder]];

    [gameWindow display];
    [gameWindow enableFlushWindow];
    [gameWindow flushWindow];

    [gameWindow makeKeyAndOrderFront:self];
}

@end

