/* indent:4  tabsize:8  font:fixed-width */

#import "SpiderGameLogic.h"
#import "SpiderSuitLogic.h"
#import "SpiderModel.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation SpiderGameLogic

- (void) clickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    if (([aCard count] == 1) && ([aCard isFaceUp] == NO))
    {
        [aCard setFaceUp:YES];
    }
    else if([aCard isFaceUp] && [aCard isAllNextInSameCardSuit] && [aCard isAllNextInDecreasingCardValue]) {
        // try to move the pile to somewhere better
        [[self gameModel] tryToMoveCardPile:aCard fromPile:aCardPileHolder];
    }
}

- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    [aCard flipCard];
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileView
{
    if ([aCardPile isFaceUp] && [aCardPile isAllNextInSameCardSuit] && [aCardPile isAllNextInDecreasingCardValue])
    {
        return YES;
    }
    return NO;
}


- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile* targetCard = [aCardPileHolder lastObject];

    if (targetCard != nil)
    {
        if (([targetCard isFaceUp]) &&
            ([targetCard cardValue] == [aCardPile cardValue] + 1))
        {
            return YES;
        }
	return NO;
    }
    return YES;
}

- (void)removedPile:(CardPile*)cPile from:(CardPileHolder*)lh
{
    [[lh lastObject] setFaceUp:YES];
}

@end

