/* indent:4  tabsize:8  font:fixed-width */

#import "Template.h"
#import "localstrings.h"

static id _templateSharedInstance = nil;


@implementation Template

+ (Template*) sharedInstance
/*"
 Instead of the old method of calling SolGameController when
 you wanted to message your game module, you now
 call [Template sharedInstance] and direct messages to
 the returned instance. You can use this to check if the game
 has been won, among other things.
"*/
{
    return _templateSharedInstance;
}


/*---------------------------------------------------------------------------
|
|    - initFromBundle:aBundle withName:(NSString*)name
|
|    returns: (id) self
|
|----------------------------------------------------------------------------
|
|    Instantiate an object of this class.
|			
\---------------------------------------------------------------------------*/

- initFromBundle:(NSBundle*)aBundle withName:(NSString*)name
/*"
 Extends our superclass method in order to set our shared
 instance variable.
"*/
{
    [super initFromBundle:aBundle withName:name];

    // This is used instead of having a global SolGameController()
    // function. It is assumed that this method will be called
    // only once and that our +sharedInstance method will return
    // the single instance.
    _templateSharedInstance = self;

    return self;
}


/*---------------------------------------------------------------------------
|
|    - inspectorWillBeRemoved
|
|----------------------------------------------------------------------------
|
|    Sent by game engine just before removing this module's inspector from
|    view.
|			
\----------------------------------------------------------------------------*/

- (void) inspectorWillBeRemoved
{
    // ****custom code here****
}


/*---------------------------------------------------------------------------
|
|    - inspectorInstalled
|
|----------------------------------------------------------------------------
|
|    Sent by game engine just after installing this module's inspector.
|			
\----------------------------------------------------------------------------*/

- (void) inspectorInstalled
{
    // ****custom code here****
}


/*---------------------------------------------------------------------------
|
|    - startGame:
|
|----------------------------------------------------------------------------
|
|    Start a new game.  Get confirmation from the user before aborting a 
|    game in progress.
|			
\----------------------------------------------------------------------------*/

- (void) startGame:sender
{
    [super startGame:sender];
    [self setupGame:YES];
}


/*---------------------------------------------------------------------------
|
|    - restartGame:
|
|----------------------------------------------------------------------------
|
|    Restart the game in progress.
|			
\----------------------------------------------------------------------------*/

- (void) restartGame:sender
{
    [super restartGame:sender];
    [self setupGame:NO];
}


/*---------------------------------------------------------------------------
|
|    - setupGame:(BOOL)redeal
|
|----------------------------------------------------------------------------
|
|    Setup a new game.  If "redeal" is true, deal a new deck, otherwise
|    use the same cards as the previous game.
|			
\----------------------------------------------------------------------------*/

- (void) setupGame:(BOOL)redeal
{
    // ****custom code here****

    // pop the game window to the front
    [gameWindow makeKeyAndOrderFront:self];
}


/*---------------------------------------------------------------------------
|
|    - endGame:sender
|
|----------------------------------------------------------------------------
|
|    End the game in progress.  Discard the game window.
|			
\----------------------------------------------------------------------------*/

- (void) endGame:sender
{
    // close the game window
    [super endGame:sender];

    // ****custom code here****
}


/*---------------------------------------------------------------------------
|
|    - win
|
|----------------------------------------------------------------------------
|
|    Called when the game has been won.  This is where you can insert fancy
|    winning routines, or just call the default (boring) routine.
|
\----------------------------------------------------------------------------*/

- (void) win
{
    [super win];  // replace this with something wonderful
}


/*---------------------------------------------------------------------------
|
|    - lose
|
|----------------------------------------------------------------------------
|
|    Called when the game has been lost.  Most games probably won't bother
|    to check if they have lost.
|
\----------------------------------------------------------------------------*/

- (void) lose
{
    [super lose];  // replace this with something wonderful
}

/*---------------------------------------------------------------------------
|
|    - checkForWin
|
|----------------------------------------------------------------------------
|
|    Called to check the state of the game.  Always override (unless your
|    game is impossible to win).
|
\----------------------------------------------------------------------------*/

- (void) checkForWin
{
#ifdef FILL_THIS_IN_YOURSELF
    if (I win the game)
    {
        [self win];
    }
#endif
}

@end

