/* indent:4  tabsize:8  font:fixed-width */

#import "TenpileGUI.h"
#import "TenpileModel.h"
#import <Solitaire/CardPileView.h>
#import <Solitaire/CardImager.h>
#import <AppKit/NSWindow.h>

@implementation TenpileGUI

- (void)setupGame
{
    int 		i;
    CardPileView*  	suitCardPiles[4];
    CardPileView*  	gameCardPiles[10];
    CardPileView*  	tempCardPiles[4];
    id*			suitHlds = [model suitPileHolders];
    id*			gameHlds = [model gamePileHolders];
    id*			tempHlds = [model tempPileHolders];

    [gameWindow disableFlushWindow];

    //----------------------------------------------------------------
    //    Sync pile id's with current game window and set 
    //    preferences and delegates
    //----------------------------------------------------------------
    
    suitCardPiles[0] = suitPileView1;
    suitCardPiles[1] = suitPileView2;
    suitCardPiles[2] = suitPileView3;
    suitCardPiles[3] = suitPileView4;
    for (i = 0; i < 4; i++)
    {
        [suitCardPiles[i] setModel:suitHlds[i]];
    }
    
    gameCardPiles[0] = gamePileView1;
    gameCardPiles[1] = gamePileView2;
    gameCardPiles[2] = gamePileView3;
    gameCardPiles[3] = gamePileView4;
    gameCardPiles[4] = gamePileView5;
    gameCardPiles[5] = gamePileView6;
    gameCardPiles[6] = gamePileView7;
    gameCardPiles[7] = gamePileView8;
    gameCardPiles[8] = gamePileView9;
    gameCardPiles[9] = gamePileView10;
    for (i = 0; i < 10; i++)
    {
        [gameCardPiles[i] setModel:gameHlds[i]];
        [gameCardPiles[i] setOffset:0.0 :[[gameCardPiles[i] cardImager] yTopSpace]];
    }
    
    tempCardPiles[0] = tempPileView1;
    tempCardPiles[1] = tempPileView2;
    tempCardPiles[2] = tempPileView3;
    tempCardPiles[3] = tempPileView4;
    for (i = 0; i < 4; i++)
    {
        [tempCardPiles[i] setModel:tempHlds[i]];
    }

    [gameWindow display];
    [gameWindow enableFlushWindow];
    [gameWindow flushWindow];

    [gameWindow makeKeyAndOrderFront:self]; 
}

@end

