/* indent:4  tabsize:8  font:fixed-width */

#import "TenpilePrefs.h"

@implementation TenpilePrefs

/*---------------------------------------------------------------------------
|
|    - registerPrefs
|
|----------------------------------------------------------------------------
|
|    Register the preferences for this game.  Called automatically.
|			
\---------------------------------------------------------------------------*/

- (void) registerPrefs
{
    NSDictionary*	defaultsDict;
	
	defaultsDict = [NSDictionary dictionaryWithObjects:[NSArray arrayWithObject:@"3"] 
		forKeys:[NSArray arrayWithObject:@"HiddenCards"]];

	[[NSUserDefaults standardUserDefaults] registerDefaults:defaultsDict];
	
    hiddenCards = [[NSUserDefaults standardUserDefaults] 
		integerForKey:@"HiddenCards"];
    if (hiddenCards < 0)
      hiddenCards = 0;
    if (hiddenCards > 4)
      hiddenCards = 4;
    [hiddenCardsMatrix selectCellWithTag:hiddenCards]; 
}


- (void) saveHiddenCards:sender
{
    hiddenCards = [hiddenCardsMatrix selectedTag];
    [[NSUserDefaults standardUserDefaults] setInteger:hiddenCards forKey:@"HiddenCards"]; 
}


- (int) hiddenCards
{
    return hiddenCards;
}

@end

