/* indent:4  tabsize:8  font:fixed-width */


#import "TenpileTempLogic.h"
#import "TenpileSuitLogic.h"
#import "TenpileModel.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>

@implementation TenpileTempLogic
    
- (void) doubleClickedCard:(CardPile*)aCard in:(CardPileHolder*)aCardPileHolder
{
    int i;
    if (([aCard count] == 1) && (![aCard isFaceUp]))
    {
        [aCard flip];
    }
    else if ([aCard count] == 1)
    {
        id* suitHlds = [(TenpileModel*)gameModel suitPileHolders];
        for (i = 0; i < 4; i++)
        {
            if ([suitHlds[i] canAcceptPile:aCard
                                      from:aCardPileHolder
                                        in:suitHlds[i]])
            {
                [aCardPileHolder dealLastObjectTo:suitHlds[i]];
                [gameModel checkForWin];
                break;
            }
        }
    } 
}

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    if ([aCardPileHolder count] == 0 && [aCardPile count] == 1)
    {
        return YES;
    }
    return NO;
}

- (BOOL) draggedPile:(CardPile*)aCardPile from:(CardPileHolder*)aCardPileHolder
{
    return YES;
}

@end

