/* indent:4  tabsize:8  font:fixed-width */

#import <Solitaire/GameModule.h>
#import <Solitaire/GamePref.h>
#import "localstrings.h"
#import <Solitaire/SmallCard.h>
#import <Solitaire/Card.h>  	
#import "Solitaire.h"


@implementation GameModule (SolitaireDependentAdditions)

/*"
    This category only exists because of dependencies between GameModule
    and the Solitaire app classes. It will likely be removed when
    everything is better organized.
"*/

- (void) win
/*"
	Called when the game has been won.  By default, invokes the generic "win" 
	routine.  Override to create custom "game won" behaviour.
"*/
{
    [[NSApp delegate] win]; 
}


- (void) commonGameSetup
/*"
	HELPER METHOD. DO NOT OVERRIDE. We load the correct game nib after
	rescanning our generic preferences.
"*/
{
    int depth;
    CardSize lastCardSize = cardSize;
    
    // if game only supports one size of card, don't bother trying to
    // load the missing size
    if (!ignoreSizePref)
        cardSize = [[NSApp delegate] cardSize];

    // generic information used in all games
    desktopColor = [[NSApp delegate] backgroundColor];
    cardBack = [[NSApp delegate] cardBack];

    // load the preferred card size
    if ((cardSize != lastCardSize) || !gameWindow)
    {
        NSString* path = nil;
        CardSize realSize;

        if ((path = [self nibPathForCardSize:cardSize realSize:&realSize]) == nil)
          {
            NSRunAlertPanel(gameName,LOCALIZED_NIBGONE_MSG,
                            @"", nil, nil);
            return;
          }

        if (realSize != cardSize)
          {
            cardSize = realSize;
            ignoreSizePref = YES;
          }
        if (cardSize != lastCardSize || !gameWindow)
          {
            if (gameWindow) [gameWindow performClose:self];

            [self loadGameWindow:path ofSize:cardSize];
          }
    }  

    // Cards need to know what background to use
    if (cardSize == CS_SMALL){
    	if(cardBack == CS_CUSTOM)
            [[SmallCard class] setCardBackImage:
                [[NSApp delegate] imageForSize:cardSize]];
        else
            [[SmallCard class] setCardBack:cardBack];
    }
    else{
    	if(cardBack == CS_CUSTOM)
	    [[Card class] setCardBackImage:
            [[NSApp delegate] imageForSize:cardSize]];
	else
            [[Card class] setCardBack:cardBack];
    }

    // Support added for a color background if using a 
    // color or 8-bit gray machine
    if ((depth = [gameWindow depthLimit]) == 0)
    {
        depth = [NSWindow defaultDepthLimit];
    }
    if (depth != NSBestDepth(NSCalibratedWhiteColorSpace, 2, 2, YES, NULL))
    {
        if (depth == NSBestDepth(NSCalibratedWhiteColorSpace, 8, 8, YES, NULL))
        {
            float grayLevel;
            [[desktopColor colorUsingColorSpaceName:NSCalibratedWhiteColorSpace] getWhite:&grayLevel alpha:NULL];
            [gameWindow setBackgroundColor:[NSColor colorWithCalibratedWhite:grayLevel alpha:1.0]];
        }
        else
        {
            [gameWindow setBackgroundColor:desktopColor];
        }
    } 
}

@end

