/* indent:4  tabsize:8  font:fixed-width */

#import <Solitaire/GameModule.h>
#import "ModuleList.h"


@implementation ModuleInfo


/*---------------------------------------------------------------------------
|
|    - initWithController:(GameModeul*) aController name:(NSString *)aName 
|                                     path:(NSString *)aPath
|
|    returns:  	(id) self	OK
|	       		(id) nil	Unable to initialize.
|
|----------------------------------------------------------------------------
|
|    Designated initializer for ModuleInfo class.  
|			
\---------------------------------------------------------------------------*/

- initWithController:(GameModule*)aController name:(NSString *)aName 
	path:(NSString *)aPath
{
    [super init];
    
    controller = aController;
    
    // get the bundle for this game
    if (aPath && [aPath length])
    {
        theBundle = [[NSBundle allocWithZone:[self zone]] initWithPath:aPath];
        if (theBundle == nil)
        {
            NSLog(@"Unable to access bundle %@ (%@)\n", aPath, aName);
            [self autorelease];
            return nil;
        }
    }
    else
    {
        NSLog(@"ModuleList:initWithView:name:path: -- invalid path\n");
	return nil;
    }
    
    realName = [aName copy];
    
    /* this lets you customize the name of the game using the 
       Localizable.strings file in the game bundle */
       
    gameName = [NSLocalizedStringFromTableInBundle(aName, nil, theBundle, 
	nil) retain];
	
    return self;
}


/*---------------------------------------------------------------------------
|
|    - setController:newController
|
|----------------------------------------------------------------------------
|
|    Set the game controller.
|			
\---------------------------------------------------------------------------*/

- (void) setController:(GameModule*)newController
{
    [controller autorelease];
    controller = [newController retain];
}


/*---------------------------------------------------------------------------
|
|    - (GameModule*) controller
|
|    returns:  (GameModule*) the controller
|
|----------------------------------------------------------------------------
|
|    Return the game controller.
|			
\---------------------------------------------------------------------------*/

- controller
{    
    return controller;
}


/*---------------------------------------------------------------------------
|
|    - setFailed:(BOOL)flag
|
|----------------------------------------------------------------------------
|
|    Set the failed flag.  Turn on the failed flag when the module has failed
|    to load.
|			
\---------------------------------------------------------------------------*/

- (void) setFailed:(BOOL)flag
{
    failed = flag; 
}


/*---------------------------------------------------------------------------
|
|    - (BOOL)failed
|
|    returns:  (BOOL) state of failed flag
|
|----------------------------------------------------------------------------
|
|    Return the failed flag.
|			
\---------------------------------------------------------------------------*/

- (BOOL) failed
{
    return failed;
}


/*---------------------------------------------------------------------------
|
|    - (NSString *) gameName
|
|    returns:  (NSString *) the name of the game
|
|----------------------------------------------------------------------------
|
|    Returns the name of this game module (localized).
|			
\---------------------------------------------------------------------------*/

- (NSString*) gameName
{    
    return gameName;
}


/*---------------------------------------------------------------------------
|
|    - (NSString *) realName
|
|    returns:  (NSString *) the real name of the game
|
|----------------------------------------------------------------------------
|
|    Returns the name of this game module (non-localized).
|			
\---------------------------------------------------------------------------*/

- (NSString *) realName
{    
    return realName;
}


/*---------------------------------------------------------------------------
|
|    - (NSString *) path
|
|    returns:  (NSString *) the path of the module
|
|----------------------------------------------------------------------------
|
|    Returns the path to this game module.
|			
\---------------------------------------------------------------------------*/

- (NSString *) path
{    
    return [theBundle bundlePath];
}


/*---------------------------------------------------------------------------
|
|    - (NSBundle *)bundle
|
|    returns:  (NSBundle *) the bundle for the module
|
|----------------------------------------------------------------------------
|
|    Returns an NXBundle corresponding to this game module.
|			
\---------------------------------------------------------------------------*/

- (NSBundle *) bundle
{    
    return theBundle;
}

/*---------------------------------------------------------------------------
|
|    - dealloc
|
|----------------------------------------------------------------------------
|
|    Deallocate this object.
|			
\---------------------------------------------------------------------------*/

- (void) dealloc
{
    [controller release];
    [gameName release];
    [realName release];
    
    // NXBundles with dynamically loaded code can't be freed; this 
    // might be a problem, but I don't think so.
    [theBundle release];
    [super dealloc]; 
}

@end

/*==========================================================================*/


@implementation ModuleList

- init
{
    [super init];
    modules = [[NSMutableArray alloc] initWithCapacity:1];
    return self;
}

- (void) dealloc
{
    [modules release];
    [super dealloc];
}

- (NSString *) nameAtIndex:(int)i
{
    return [[modules objectAtIndex:i] gameName];
}

- (NSString *) realNameAtIndex:(int)i
{
    return [[modules objectAtIndex:i] realName];
}

- controllerAtIndex:(int)i
{
    return [[modules objectAtIndex:i] controller]; 
}

- (NSString *) pathAtIndex:(int)i
{
    return [[modules objectAtIndex:i] path];
}

static int docompare(id x, id y, void *nothing)
{
    return [[x realName] compare:[y realName] 
	options:NSCaseInsensitiveSearch];
}

- (void) sort
{
    [modules sortUsingFunction:docompare context:(void*)NULL];
}

- (unsigned int) count
{
    return [modules count];
}

- objectAtIndex:(unsigned)index
{
    return [modules objectAtIndex:index];
}

- (void) addObject:anObject
{
    [modules addObject:anObject];
}

@end

