/* NSString+whitespace.m created by sanguish on Thu 25-Feb-1999 */

#import "NSString+whitespace.h"

@implementation NSString(whitespace)

- (NSString *)stringByRemovingSurroundingWhitespace;
{
    static NSCharacterSet *nonWhitespace = nil;
    NSRange firstValidCharacter, lastValidCharacter;

    if (!nonWhitespace) {
        nonWhitespace = [[[NSCharacterSet characterSetWithCharactersInString:
            @" \t\r\n"] invertedSet] retain];
    }

    firstValidCharacter = [self rangeOfCharacterFromSet:nonWhitespace];
    if (firstValidCharacter.length == 0)
        return @"";
    lastValidCharacter = [self rangeOfCharacterFromSet:nonWhitespace options:NSBackwardsSearch];

    if (firstValidCharacter.location == 0 && lastValidCharacter.location == [self length] - 1)
        return self;
    else
        return [self substringWithRange:NSUnionRange(firstValidCharacter, lastValidCharacter)];
}


- (NSArray *)stringsByAppendingComponentToPaths:(NSArray *)strings
{
    NSMutableArray *tempStrings=[NSMutableArray array];
    NSArray *tempArray;
    NSEnumerator *stringsEnumerator;
    NSString *string;

    stringsEnumerator=[strings objectEnumerator];
    while (string=[stringsEnumerator nextObject])
      {
        NSString *tempString;

        tempString=[string stringByAppendingPathComponent:self];
        [tempStrings addObject:tempString];
      }
    tempArray=[NSArray arrayWithArray:tempStrings];
    return tempArray;
}

@end
