/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    Preferences : NSObject
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/


#import <AppKit/AppKit.h>
#import <Solitaire/CardSet.h>

#define IBOutlet

@interface Preferences:NSObject
{
    IBOutlet NSColorWell*	backgroundColorWell;
    IBOutlet NSMatrix*		cardBackMatrix;
    IBOutlet NSMatrix*		cardSizeMatrix;
    IBOutlet NSButton*     	preDrawSwitch;
    IBOutlet NSPanel*		preferencesPanel;
    IBOutlet NSPanel*		statusPanel;
    IBOutlet NSTextField*	messageField;

    NSImage*	cardBackImage;
    NSImage*	sCardBackImage;
    NSColor* 	backgroundColor;
//    CardSize 	cardSize;
//    CardBack 	cardBack;
    BOOL 		preDrawCards;
    NSString*	imageFileName;
    BOOL 		foundFile;
}

- init;
- (void) defaults:sender;
- (void) saveColor:sender;
//- (void) saveCardSize:sender;
//- (void) saveCardBack:sender;
- (void) savePreDrawState:sender;
- (void) setNewImage:sender;
- (void) showPreferences:sender;
//- (CardSize) cardSize;
//- (CardSize) cardBack;
- (NSColor *) backgroundColor;
//- (NSImage*) imageForSize:(CardSize)aSize;
- (unsigned int) draggingEntered:(id <NSDraggingInfo>)sender;
- (unsigned int) draggingUpdated:(id <NSDraggingInfo>)sender;
- (BOOL) prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL) performDragOperation:(id <NSDraggingInfo>)sender;
- (void) concludeDragOperation:(id <NSDraggingInfo>)sender;

@end
