// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniLibrarian/OLIndexedFolder.h,v 1.6 1998/03/23 10:13:26 andrew Exp $

#import <Foundation/NSObject.h>

@class NSCalendarDate, NSDictionary, NSMutableDictionary;
@class OAIIndex;

@interface OLIndexedFolder : NSObject
{
    OAIIndex *index;
    NSString *indexFilename;
    NSString *folder;
    NSString *label;
    NSCalendarDate *lastUpdated;
}

- initWithIndexFilename:(NSString *)filename forFolder:(NSString *)folderName label:(NSString *)aLabel lastUpdate:(NSCalendarDate *)last;
- initWithInfoDictionary:(NSDictionary *)dict;

- (BOOL)isIndexed;
- (OAIIndex *)index;
- (NSString *)indexFilename;
- (NSString *)folder;
- (NSString *)label;
- (void)setLabel:(NSString *)newLabel;
- (NSCalendarDate *)lastUpdated;
- (NSMutableDictionary *)infoDictionary;
- (void)updateIndex;

@end
