// Copyright 1998 Omni Development, Inc.  All rights reserved.

#import "OWShelfFormatter.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>

#import "OLIndexedFolder.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniLibrarian/OWShelfFormatter.m,v 1.5 1998/03/23 10:13:27 andrew Exp $")

@implementation OWShelfFormatter

#define TEXT_HEIGHT 15
#define TEXT_SPACING 2
#define ICON_EDGE_SIZE 48

static NSFont *shelfFont;
static NSSize hiliteSize;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    shelfFont = [[NSFont userFontOfSize:12.0] retain];
    if (!shelfFont)
	shelfFont = [[NSFont fontWithName:@"Helvetica" size:12.0] retain];

    hiliteSize = NSMakeSize(66, 52);
}


// OWShelfViewFormatter protocol

- (void)drawEntry:(id)shelfEntry inRect:(NSRect)spot ofShelf:(OWShelfView *)shelf selected:(BOOL)isSelected dragging:(BOOL)isMoving;
{
    OLIndexedFolder *index;
    NSPoint drawSpot;
    NSImage *image;
    NSSize imageSize;
    NSRect textRect;

    index = shelfEntry;
    image = [[NSWorkspace sharedWorkspace] iconForFile:[index folder]];
    imageSize = [image size];
    drawSpot.x = NSMidX(spot) - imageSize.width / 2.0;
    drawSpot.y = NSMidY(spot) + (imageSize.height - TEXT_HEIGHT - TEXT_SPACING) / 2.0;

    if (isSelected)
        [shelf drawRoundedRect:NSMakeRect(NSMidX(spot) - hiliteSize.width / 2.0, NSMidY(spot) - (hiliteSize.height + TEXT_HEIGHT + TEXT_SPACING) / 2.0, hiliteSize.width, hiliteSize.height) cornerRadius:12 color:[NSColor selectedControlColor]];

    [image compositeToPoint:drawSpot operation:NSCompositeSourceOver];

    if ([index isIndexed]) {
        NSImage *indexTagImage;
        NSPoint tagDrawSpot;

        indexTagImage = [NSImage imageNamed:@"indexTag.tiff"];
        tagDrawSpot = drawSpot;
        tagDrawSpot.x = tagDrawSpot.x + imageSize.width - [indexTagImage size].width;
        [indexTagImage compositeToPoint:tagDrawSpot operation:NSCompositeSourceOver];
    }

    if (isMoving) {
        // Draw image all greyed out, and stuff
        [[NSColor controlColor] set];
        PSsetalpha(.4);
        PScompositerect(drawSpot.x, drawSpot.y - ICON_EDGE_SIZE, imageSize.width, ICON_EDGE_SIZE, NSCompositeSourceOver);
    }
    
    textRect = NSMakeRect(NSMinX(spot) + TEXT_SPACING + 1.0, drawSpot.y + TEXT_SPACING, NSWidth(spot) - (TEXT_SPACING + 1.0) * 2.0, TEXT_HEIGHT);

    if (isSelected) {
        [[NSColor selectedControlColor] set];
        NSRectFill(textRect);
    }

    [[index label] drawWithFont:shelfFont color:(isSelected ? [NSColor selectedTextColor] : [NSColor textColor]) alignment:NSCenterTextAlignment rectangle:textRect];
}

@end
