/* Generator.m created by tthomas on Tue 07-Dec-1999 */

#import <Foundation/Foundation.h>
#import <Foundation/NSPathUtilities.h>
#import "MiscMergeTemplate.h"
#import "MiscMergeEngine.h"
#import "Declaration.h"
#import "ResourceLocator.h"

#import "Generator.h"


@implementation Generator

+ (Generator*) generatorWithInput:(NSString*)inString
/*"
**	inString should be the whole string that was passed to us. We'll do simple
**	parsing to come up with the output string.
"*/
{
    return [[[Generator alloc] initWithInput:inString] autorelease];
}

- (id) initWithInput:(NSString*)inString
{
    [super init];

    [self _setupResourceLocator];
    _inString = [inString copy];

    return self;
}

- (void) dealloc
{
    [_locator release];
    [_inString release];
    [_generatedDeclarations release];

    [super dealloc];
}

- (NSString*) inString
{
    return _inString;
}

- (ResourceLocator*) resourceLocator
{
    return _locator;
}

- (NSString*) generateOutputUsingTemplateName:(NSString*)templateName
/*"
**	Generates the entire output string using the template named templateName.
"*/
{
    NSMutableString* outString = [NSMutableString string];
    NSEnumerator* declarationsEnum = [[self generatedDeclarations] objectEnumerator];
    Declaration* aDeclaration = nil;
    NSString* pathToTemplate = [[self resourceLocator] findResourceNamed:templateName];
    MiscMergeTemplate* template = [[MiscMergeTemplate alloc] initWithContentsOfFile:pathToTemplate];

    while ((aDeclaration = [declarationsEnum nextObject]) != nil) {
        [outString appendString:
            [self _mergeUsingDeclaration:aDeclaration template:template]];
    }

    return outString;
}
       

- (NSArray*) generatedDeclarations
/*"
**	Returns instances of our Declaration class, one for each row that was
**	successfully parsed.
"*/
{
    if (_generatedDeclarations == nil) {
        [self _generateDeclarationsFromInputString];
    }
    
    return _generatedDeclarations;
}

- (void) _generateDeclarationsFromInputString
/*"
**	Parses the input string to create our Declaration instances.
"*/
{
    NSMutableArray* declarations = [NSMutableArray array];
    NSString* inString = [self inString];
    NSEnumerator* linesEnum = [[inString componentsSeparatedByString:[NSString stringWithCString:"\n"]] objectEnumerator];
    NSString* line = nil;
    NSMutableCharacterSet* charsToSkip = [[NSCharacterSet whitespaceCharacterSet] mutableCopy];
    NSMutableCharacterSet* alphaCharacterSet = [[NSCharacterSet alphanumericCharacterSet] mutableCopy];

    // Oops, we should probably scan for the * so we can tell the diff
    // between int and int*.
    [charsToSkip addCharactersInString:@"*;"];
    //  Variables sometimes start with underscores and java variable declarations
    // can have dots in them.
    [alphaCharacterSet addCharactersInString:@"_."];
    
    while ((line = [linesEnum nextObject]) != nil) {
        Declaration* newDeclaration = nil;
        NSScanner* scanner = [NSScanner scannerWithString:line];
        NSString* type = nil;
        NSString* ivar = nil;

		// POSSIBLE FIX FOR JAVA ACCESS keywords
        [scanner setCharactersToBeSkipped:charsToSkip];

		[scanner scanString:@"protected" intoString:NULL];
		[scanner scanString:@"public" intoString:NULL];
		[scanner scanString:@"private" intoString:NULL];

        [scanner setCharactersToBeSkipped:charsToSkip];
        [scanner scanUpToCharactersFromSet:alphaCharacterSet intoString:NULL];
        [scanner scanCharactersFromSet:alphaCharacterSet intoString:&type];
        [scanner scanCharactersFromSet:alphaCharacterSet intoString:&ivar];

#if DEBUG
        NSLog (@"Parsed line %@. type=%@, ivar=%@", line, type, ivar);
#endif
        newDeclaration = [Declaration declarationWithType:type ivar:ivar];
        if (newDeclaration != nil) {
            [declarations addObject:newDeclaration];
        }
        else {
            NSLog (@"Couldn't scan line: %@", line);
        }
    }

    // The release is just in case this method is called more than once
    // (though it shouldn't be).
    [_generatedDeclarations release]; 
    _generatedDeclarations = [[NSArray alloc] initWithArray:declarations];
    
    [charsToSkip release];
}

- (NSString*) _mergeUsingDeclaration:(Declaration*)aDeclaration template:(MiscMergeTemplate*)template
{
    NSString* output = @"";
    MiscMergeEngine* mergeEngine = [[MiscMergeEngine alloc] init];

    [mergeEngine setTemplate:template];
    [mergeEngine setMainObject:aDeclaration];
    output = [mergeEngine execute:nil];
    // Releasing the mergeEngine below releases output so retain it first.
    [output retain];

    [mergeEngine release];

    return [output autorelease];
}

- (void) _setupResourceLocator
{
    // The order of the array returned from the function below is the
    // user's home dir, local library, network library, and system library
    // (just the order we want to search).
    NSEnumerator* standardLibPathsEnum = [NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSAllDomainsMask, YES) objectEnumerator];
    NSString* libPath = nil;

    _locator = [[ResourceLocator alloc] init];

    while ((libPath = [standardLibPathsEnum nextObject]) != nil) {
        NSString* pathToCodeGenFolder = [libPath stringByAppendingPathComponent:@"CodeGen"];
        // The locator makes sure the path exists before adding it.
        [_locator addToSearchPaths:pathToCodeGenFolder];
    }
}

@end
