//
//	NSString+MiscRegex.h -- add regular expression support to NSString
//		Written by Carl Lindberg Copyright (c) 1998 by Carl Lindberg.
//				  Version 1.01   All rights reserved.
//		This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	


#import <Foundation/NSString.h>
#import "regexpr.h"
//#import <misckit/regexpr.h>

/*
 * Additional flags you can pass with the options parameter:
 * 
 * MiscFasterSearch will use the fastmap feature of the regexpr package.
 * This will result in faster searches on longer strings, but the overhead
 * may not be worth it with short strings.
 * 
 * MiscUseMatchSubstitutions will turn on special processing on the
 * 'replace string' used in the -stringByReplacingEveryOccurrenceOfRegex...
 * and -stringByReplacingRegex... methods. A string of the form '$<digit>'
 * will be replaced with the text matched by the <digit>'th parenthesized
 * subexpression.  For example, for the regex "aa(b+)", "$1" would be
 * replaced with the string of b's matched by the "b+" part of the regex.
 * "$0" and "&" are special tokens that will be replaced with the entire
 * matched text. Use "$$" and "$&" if you want a literal '$' or '&'.
 */
enum
{
    MiscFasterSearch = 4096,
    MiscUseMatchSubstitutions = 8192
};


extern NSString *MiscRegexException;


/* Keys used for the grep: methods */

extern NSString *MiscBeforePiece;
extern NSString *MiscMiddlePiece;
extern NSString *MiscAfterPiece;
extern NSString *MiscBeforeRangePiece;
extern NSString *MiscMiddleRangePiece;
extern NSString *MiscAfterRangePiece;
extern NSString *MiscSubstringsPiece;
extern NSString *MiscSubrangesPiece;

/* Functions to get regexp_t structures for use in RegexStruct functions */
regexp_t MiscNewRegexStruct(NSString *regexString, unsigned options);
void     MiscFreeRegexStruct(regexp_t pattern);

@class NSDictionary, NSArray;

@interface NSString (MiscRegex)

- (unsigned)numOfRegex:(NSString *)regex options:(unsigned)mask range:(NSRange)range;
- (NSRange)rangeOfRegex:(NSString *)regex options:(unsigned)mask occurrenceNum:(int)n
			range:(NSRange)range;

- grep:(NSString *)regex forPiece:(NSString *)key options:(unsigned)mask occurrenceNum:(int)n;
- (NSDictionary *)grep:(NSString *)regex forPieces:(NSArray *)keys
			options:(unsigned)mask occurrenceNum:(int)n;

- (NSString *)stringByReplacingEveryOccurrenceOfRegex:(NSString *)regex
			withString:(NSString *)aString options:(unsigned)mask range:(NSRange)range;

- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString 
			options:(unsigned)mask occurrenceNum:(int)n range:(NSRange)range;

- (NSArray *)stringsMatchedByRegex:     (NSString *)regex options:(unsigned)mask;
- (NSArray *)rangesMatchedByRegex:      (NSString *)regex options:(unsigned)mask;
- (NSArray *)componentsSeparatedByRegex:(NSString *)regex options:(unsigned)mask;

- (BOOL)containsRegex:(NSString *)regex;

- (BOOL)isValidRegex;


/*
 * The same methods as above, but taking a precompiled regex structure
 * instead of an NSString.
 */
- (unsigned)numOfRegexStruct:(regexp_t)pattern options:(unsigned)mask range:(NSRange)range;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern options:(unsigned)mask occurrenceNum:(int)n
			range:(NSRange)range;

- grepRegexStruct:(regexp_t)pattern forPiece:(NSString *)key options:(unsigned)mask
			occurrenceNum:(int)n;
- (NSDictionary *)grepRegexStruct:(regexp_t)pattern forPieces:(NSArray *)keys
			options:(unsigned)mask occurrenceNum:(int)n;

- (NSString *)stringByReplacingEveryOccurrenceOfRegexStruct:(regexp_t)pattern
			withString:(NSString *)aString options:(unsigned)mask range:(NSRange)range;

- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
			withString:(NSString*)replaceString
			options:(unsigned)mask occurrenceNum:(int)n range:(NSRange)range;

- (NSArray *)stringsMatchedByRegexStruct:     (regexp_t)pattern options:(unsigned)mask;
- (NSArray *)rangesMatchedByRegexStruct:      (regexp_t)pattern options:(unsigned)mask;
- (NSArray *)componentsSeparatedByRegexStruct:(regexp_t)pattern options:(unsigned)mask;

#ifndef _HEADER_VIEWER_  /* convenience methods */

- (unsigned)numOfRegex:(NSString *)regex;
- (unsigned)numOfRegex:(NSString *)regex options:(unsigned)mask;
- (unsigned)numOfRegex:(NSString *)regex range:(NSRange)range;

- (NSRange)rangeOfRegex:(NSString *)regex;
- (NSRange)rangeOfRegex:(NSString *)regex options:(unsigned)mask;
- (NSRange)rangeOfRegex:(NSString *)regex occurrenceNum:(int)n;
- (NSRange)rangeOfRegex:(NSString *)regex options:(unsigned)mask occurrenceNum:(int)n;
- (NSRange)rangeOfRegex:(NSString *)regex range:(NSRange)range;
- (NSRange)rangeOfRegex:(NSString *)regex options:(unsigned)mask range:(NSRange)range;
- (NSRange)rangeOfRegex:(NSString *)regex occurrenceNum:(int)n range:(NSRange)range;

- (NSDictionary *)grep:(NSString *)regex forPieces:(NSArray *)keys;
- (NSDictionary *)grep:(NSString *)regex forPieces:(NSArray *)keys options:(unsigned)mask;
- (NSDictionary *)grep:(NSString *)regex forPieces:(NSArray *)keys occurrenceNum:(int)n;

- grep:(NSString *)regex forPiece:(NSString *)keys;
- grep:(NSString *)regex forPiece:(NSString *)keys options:(unsigned)mask;
- grep:(NSString *)regex forPiece:(NSString *)keys occurrenceNum:(int)n;

- (NSString *)stringByReplacingEveryOccurrenceOfRegex:(NSString *)regex
		withString:(NSString *)aString;
- (NSString *)stringByReplacingEveryOccurrenceOfRegex:(NSString *)regex
		withString:(NSString *)aString options:(unsigned)mask;
- (NSString *)stringByReplacingEveryOccurrenceOfRegex:(NSString *)regex
		withString:(NSString *)aString range:(NSRange)range;

- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString;
- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString
		options:(unsigned)mask;
- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString
		occurrenceNum:(int)n;
- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString
		options:(unsigned)mask occurrenceNum:(int)n;
- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString
		range:(NSRange)range;
- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString
		options:(unsigned)mask range:(NSRange)range;
- (NSString *)stringByReplacingRegex:(NSString*)regex withString:(NSString*)replaceString
		occurrenceNum:(int)n range:(NSRange)range;

- (NSArray *)stringsMatchedByRegex:(NSString *)regex;
- (NSArray *)rangesMatchedByRegex:(NSString *)regex;
- (NSArray *)componentsSeparatedByRegex:(NSString *)regex;

- (unsigned)numOfRegexStruct:(regexp_t)pattern;
- (unsigned)numOfRegexStruct:(regexp_t)pattern options:(unsigned)mask;
- (unsigned)numOfRegexStruct:(regexp_t)pattern range:(NSRange)range;

- (NSRange)rangeOfRegexStruct:(regexp_t)pattern;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern options:(unsigned)mask;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern occurrenceNum:(int)n;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern options:(unsigned)mask occurrenceNum:(int)n;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern range:(NSRange)range;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern options:(unsigned)mask range:(NSRange)range;
- (NSRange)rangeOfRegexStruct:(regexp_t)pattern occurrenceNum:(int)n range:(NSRange)range;

- (NSDictionary *)grepRegexStruct:(regexp_t)pattern forPieces:(NSArray *)keys;
- (NSDictionary *)grepRegexStruct:(regexp_t)pattern forPieces:(NSArray *)keys
		options:(unsigned)mask;
- (NSDictionary *)grepRegexStruct:(regexp_t)pattern forPieces:(NSArray *)keys
		occurrenceNum:(int)n;

- grepRegexStruct:(regexp_t)pattern forPiece:(NSString *)keys;
- grepRegexStruct:(regexp_t)pattern forPiece:(NSString *)keys options:(unsigned)mask;
- grepRegexStruct:(regexp_t)pattern forPiece:(NSString *)keys occurrenceNum:(int)n;

- (NSString *)stringByReplacingEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)aString;
- (NSString *)stringByReplacingEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)aString options:(unsigned)mask;
- (NSString *)stringByReplacingEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)aString range:(NSRange)range;

- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString*)replaceString;
- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString*)replaceString options:(unsigned)mask;
- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString*)replaceString occurrenceNum:(int)n;
- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString*)replaceString options:(unsigned)mask occurrenceNum:(int)n;
- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString*)replaceString range:(NSRange)range;
- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString *)replaceString options:(unsigned)mask range:(NSRange)range;
- (NSString *)stringByReplacingRegexStruct:(regexp_t)pattern
		withString:(NSString *)replaceString occurrenceNum:(int)n range:(NSRange)range;

- (NSArray *)stringsMatchedByRegexStruct:(regexp_t)pattern;
- (NSArray *)rangesMatchedByRegexStruct:(regexp_t)pattern;
- (NSArray *)componentsSeparatedByRegexStruct:(regexp_t)pattern;

#endif

@end


@interface NSMutableString (MiscRegex)

- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString 
		options:(unsigned)mask occurrenceNum:(int)n range:(NSRange)range;

- (void)replaceEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)replaceString options:(unsigned)mask range:(NSRange)range;

- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		options:(unsigned)mask occurrenceNum:(int)n range:(NSRange)range;

- (void)replaceEveryOccurrenceOfRegex:(NSString *)regex withString:(NSString *)replaceString 
		options:(unsigned)mask range:(NSRange)range;


#ifndef _HEADER_VIEWER_  /* convenience methods */

- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString;
- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString
		options:(unsigned)mask;
- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString
		occurrenceNum:(int)n;
- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString
		options:(unsigned)mask occurrenceNum:(int)n;
- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString
		range:(NSRange)range;
- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString
		options:(unsigned)mask range:(NSRange)range;
- (void)replaceRegex:(NSString *)regex withString:(NSString *)replaceString
		occurrenceNum:(int)n range:(NSRange)range;

- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString;
- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		options:(unsigned)mask;
- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		occurrenceNum:(int)n;
- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		options:(unsigned)mask occurrenceNum:(int)n;
- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		range:(NSRange)range;
- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		options:(unsigned)mask range:(NSRange)range;
- (void)replaceRegexStruct:(regexp_t)pattern withString:(NSString *)replaceString
		occurrenceNum:(int)n range:(NSRange)range;


- (void)replaceEveryOccurrenceOfRegex:(NSString *)regex withString:(NSString *)replaceString;
- (void)replaceEveryOccurrenceOfRegex:(NSString *)regex withString:(NSString *)replaceString
		options:(unsigned)mask;
- (void)replaceEveryOccurrenceOfRegex:(NSString *)regex withString:(NSString *)replaceString
		range:(NSRange)range;

- (void)replaceEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)replaceString;
- (void)replaceEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)replaceString options:(unsigned)mask;
- (void)replaceEveryOccurrenceOfRegexStruct:(regexp_t)pattern
		withString:(NSString *)replaceString range:(NSRange)range;

#endif

@end

