//
//  _MiscMergeIdentifyCommand.m
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "_MiscMergeIdentifyCommand.h"
#import <MiscFoundation.subproj/NSString+MiscAdditions.h>

@implementation _MiscMergeIdentifyCommand

- (void)dealloc
{
	[field1 release];
	[field2 release];
	[super dealloc];
}

- (BOOL)parseFromScanner:(NSScanner *)aScanner template:(MiscMergeTemplate *)template;
{
	MiscMergeConditionalOperator operator;

	[self eatKeyWord:@"identify" fromScanner:aScanner isOptional:NO];

	field1 = [self getArgumentStringFromScanner:aScanner toEnd:NO];
	field1 = [[field1 stringByTrimmingWhitespace] retain];

	operator = [self getConditionalFromScanner:aScanner];
	if (operator != MiscMergeOperatorEqual) {
		[self error_conditional:@"Identify requires operator to be an =."];
	}

	field2 = [[self getArgumentStringFromScanner:aScanner toEnd:YES] retain];

	return YES;
}

- (void)executeForMerge:(MiscMergeEngine *)aMerger
{
	[aMerger setLocalValue:[aMerger valueForField:field2] forKey:field1];
}

@end
