//
//  _MiscMergeLoopCommand.m
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "_MiscMergeLoopCommand.h"
#import <Foundation/NSUtilities.h>
#import <Foundation/NSArray.h>
#import "MiscMergeCommandBlock.h"

@implementation _MiscMergeLoopCommand

- init
{
	[super init];
	commandBlock = [[MiscMergeCommandBlock alloc] initWithOwner:self];
	return self;
}

- (void)dealloc
{
	[indexName release];
	[loopName release];
	[commandBlock release];
	[super dealloc];
}

- (BOOL)parseFromScanner:(NSScanner *)aScanner template:(MiscMergeTemplate *)template
{
	[self eatKeyWord:@"loop" fromScanner:aScanner isOptional:NO];
	
	indexName  = [[self getArgumentStringFromScanner:aScanner toEnd:NO] retain];
	start      = [[self getArgumentStringFromScanner:aScanner toEnd:NO] intValue];
	stop       = [[self getArgumentStringFromScanner:aScanner toEnd:NO] intValue];
	step       = [[self getArgumentStringFromScanner:aScanner toEnd:NO] intValue];
	loopName   = [[self getArgumentStringFromScanner:aScanner toEnd:YES] retain];

	[template pushCommandBlock:commandBlock];

	if (step == 0)
	{
		NSLog(@"%@: Loop %@ is infinite.  Setting to 1 or -1.", [self class], loopName);
		step = (start <= stop)? 1 : -1;
	}

	if (((start < stop) && (step < 0)) || ((start > stop) && (step > 0)))
	{
		NSLog(@"%@: Loop %@ is probably longer than you want. (start,end,step) = (%d,%d,%d).",
			[self class], loopName, start, stop, step);
	}

	return YES;
}

- (NSString *)loopName
{
	return loopName;
}

- (void)handleEndLoopInTemplate:(MiscMergeTemplate *)template
{
	[template popCommandBlock:commandBlock];
}

- (void)executeForMerge:(MiscMergeEngine *)aMerger
{
	NSMutableDictionary *loopContext = [NSMutableDictionary dictionary];
	int theIndex;

	[aMerger addContextObject:loopContext];
	for (theIndex = start; (step > 0)? theIndex <= stop : theIndex >= stop; theIndex += step)
	{
		[loopContext setObject:[NSString stringWithFormat:@"%d", theIndex] forKey:indexName];
		[aMerger executeCommandBlock:commandBlock];
	}
	[aMerger removeContextObject:loopContext];
}

@end

