/* NSString_CGExtension.m created by tthomas on Fri 10-Dec-1999 */

#import "NSString_CGExtension.h"

@implementation NSString (CGExtension)

- (NSString*) firstCharacterCapitalizedString
/*"
**	Unlike #capitalizeString we only capitalize the first character.
"*/
{
    NSString* 	capitalizedString = nil;

    // If we are longer than a single character,
    // capitalize the first character and tack on the remaining
    // in the existing case. Not very efficient I'm sure but it works.
    if ([self length] > 1) {
        capitalizedString = [NSString stringWithFormat:@"%@%@",
                             [[self substringToIndex:1] capitalizedString],
                             [self substringFromIndex:1]];
    }
    // If the attribute is a single character, just capitalize it.
    else {
        // (If it's nil then this will do nothing.)
        capitalizedString = [self capitalizedString];
    }

    return capitalizedString;
}

@end
