/* ResourceLocator.h created by tthomas on Fri 10-Dec-1999 */

#import <Foundation/NSObject.h>

@class NSArray;
@class NSMutableArray;


@interface ResourceLocator : NSObject
{
    NSMutableArray* _searchPaths;
    BOOL _searchInMainBundle;
}

- (id) initWithSearchPaths:(NSArray*)paths;
- (void) dealloc;

- (BOOL) searchInMainBundle;
- (void) setSearchInMainBundle:(BOOL)newSearchInMainBundle;

- (NSArray*) searchPaths;
- (void) addToSearchPaths:(NSString*)path;
- (void) addArrayOfPathsToSearchPaths:(NSArray*)paths;
- (void) removeFromSearchPaths:(NSString*)path;

- (NSString*) findResourceNamed:(NSString*)resourceName;

@end
