#import <Foundation/NSObject.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSString.h>
#import <AppKit/NSDragging.h>
#import <AppKit/NSImage.h>

#import "IKBrowserManager.h"
@class IKAnnouncer;

typedef struct _folderflags {
	int		draggable:1;
	int		dragAccepting:1;
	int		editable:1;
	int		hidden:1;
	int		leaf:1;
	int		freeing:1;
} folderFlags;

@interface IKFolder : NSObject 
<IKIconObject, IKGraphNode>
{
	NSString		*name;
	
	IKAnnouncer		*users;
	NSImage			*image,
					*miniImage,
					*acceptingDragImage,
					*miniAcceptingDragImage;
	id				dragging;
	NSMutableArray	*parents,
					*children;
	
	int				draggingSession,
					searchMarker;
		
	unsigned int	operationMask;
	folderFlags		flags;
}
+ (void)initialize;
+ multipleSelectionClass;
- (NSImage *) getIBImage;
- (NSString *) inspectorClassName;
- init;
- init: (NSString *) theName;
- (IKFolder *)copyWithZone:(NSZone *)zone;
- (void)dealloc;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder; ;
- (void)addUser:(id)who;
- (void)addListener:(id)who;
- (void)removeListener: who;
- (void)removeUser:(id)who;
- (void)checkForFree;
- (BOOL) garbageCollect;
- (NSImage *)image;
- (NSImage *)miniImage;
- (NSImage *)acceptingDragImage;
- (NSImage *)miniAcceptingDragImage;
- (NSString *)name;
- (BOOL) isDraggable;
- (BOOL) isDragAccepting;
- (BOOL) isEditable;
- (BOOL) isHidden;
- (BOOL) isLeaf;
- (NSArray *)parents;
- (NSArray *)children;
- setDraggable: (BOOL) flag;
- setDragAccepting: (BOOL) flag;
- (void)setEditable:(BOOL)flag;
- setHidden: (BOOL) flag;
- (void)setLeaf:(BOOL)flag;
- (void)setName:(NSString *)theName;
- (void)setImage:(NSImage *)theImage;
- (void)setMiniImage:(NSImage *)theImage;
- (void)setAcceptingDragImage:(NSImage *)theImage;
- (void)setMiniAcceptingDragImage:(NSImage *)theImage;
- (NSArray *)pathToNode:(IKFolder *)destination;
- (NSArray *)pathFromNode:(IKFolder *)source;
- (NSMutableArray *)searchFor:(IKFolder *)goal  via: (SEL) getNext;
- (void)addChild: child;
- (void)addChildren:(NSArray *)theChildren;
- (void)addParent:(IKFolder *)parent;
- (void)removeChild:(IKFolder *)child withAnnouncement:(BOOL)yesNo;
- (void)removeChild:(IKFolder *)child;
- (void)removeChildren:(NSArray *)theChildren withAnnouncement:(BOOL)yesNo;
- (void)removeChildren:(NSArray *)theChildren;
- (void)removeParent: parent;
- (unsigned int) draggingEntered: (id <NSDraggingInfo>) sender;
- (unsigned int) draggingUpdated: (id <NSDraggingInfo>) sender;
- (unsigned int) draggingOperation: (id <NSDraggingInfo>) sender;
- (BOOL) performDragOperation: (id <NSDraggingInfo>) sender;
+ (NSArray *)pasteTypes;
- (void)copyToPasteboard: (NSPasteboard *) pboard;
+ (id)readFromPasteboard: (NSPasteboard *) pboard;

@end

