#import <Foundation/NSObject.h>
#import <Foundation/NSArray.h>
#import "IKIconObject.h"
#import "IKDependency.h"
@class IKAnnouncer;

@interface  IKList:NSObject
<IKDependency,IKDraggableObject>
{
	NSMutableArray	*embeddedArray;
	IKAnnouncer		*users;
}

+ (void)initialize;
- (NSImage *) getIBImage;
- init;
- initCount: (unsigned int) numSlots;
- copyWithZone: (NSZone *) zone;
- (void)dealloc;
- (void)forwardInvocation:(NSInvocation *)anInvocation;
- (NSMethodSignature *)methodSignatureForSelector:(SEL)aSelector;
- (BOOL) respondsToSelector: (SEL) method;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;
- (void)addUser: who;
- (void)addListener: who;
- (void)removeListener: who;
- (void)removeUser: who;
- (BOOL) garbageCollect;
- (NSString *)name;
- (id)image;
- (id)miniImage;
- (NSString *)descrition;
- (BOOL)isDraggable;
- (BOOL) isDragAccepting;
- (BOOL) isEditable;
- (void)setDraggable: (BOOL)flag; ;
- (void)appendList: (NSArray *)objects;
- (void)removeList: (NSArray *) objects;
- (unsigned)count;
- (id)objectAtIndex:(unsigned)i;
- (void)addObject:anObject;
- insertObject: object  atIndex: (unsigned int) i;
- (void)removeObjectAtIndex: (unsigned int) i;
- (void)willFree: who;
+ (NSArray *) pasteTypes;
- (void)copyToPasteboard: (NSPasteboard *) pboard;
+ readFromPasteboard: (NSPasteboard *) pboard; ;

@end


@interface NSObject (IKListAnnouncements)
- (BOOL)list:sender  willAppendList: objects;
- (BOOL)list:sender  willRemoveList: objects;
- (BOOL)list:sender  willAdd: object;
- (BOOL)list:sender  willRemove:object;
- (void)list: sender didAppendList: objects;
- (void)list: sender didRemoveList: objects;
- (void)list: sender didAdd: object;
- (void)list: sender didRemove: object;
- (void)willFree: sender;

@end

