#import <AppKit/NSImage.h>
#import "IKIconObject.h"
#import "IKList.h"

#import <Foundation/NSString.h>
#import <AppKit/NSDragging.h>

@interface IKSuitcase: IKList
<IKEditableObject, IKDragAcceptingObject>
{
NSString		* name,
				* classToHold;

NSImage			*image,
				*miniImage,
				*acceptingDragImage,
					*miniAcceptingDragImage;
id				dragging;

int				draggingSession;

unsigned int	op;
}
+ (void)initialize;
- (NSImage *) getIBImage;
- (NSString *) inspectorClassName;
- init;
- init: (NSString *) theName  count: (unsigned) n;
- init: (NSString *) theName;
- initCount: (unsigned) n;
- (IKSuitcase *)copyWithZone: (NSZone *) zone;
- (void)dealloc;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder; ;
- (NSImage *)image;
- (NSImage *)miniImage;
- (NSImage *)acceptingDragImage;
- (NSImage *)miniAcceptingDragImage;
- (NSString *)name;
- (BOOL) isEditable;
- (BOOL) isDraggable;
- (BOOL) isDragAccepting;
- (NSString *) classToHold;
- (void)setEditable:(BOOL)flag;
- setDragAccepting: (BOOL) flag;
- (void)setName:(NSString *)theName;
- (void)setImage:(NSImage *)theImage;
- (void)setMiniImage:(NSImage *)theImage;
- (void)setAcceptingDragImage:(NSImage *)theImage;
- (void)setMiniAcceptingDragImage:(NSImage *)theImage;
- (void)setClassToHold: (NSString *) class;
- (unsigned int) draggingEntered: (id <NSDraggingInfo>) sender;
- (BOOL) performDragOperation: (id <NSDraggingInfo>) sender;
- (unsigned int) draggingUpdated: (id <NSDraggingInfo>) sender;
- (void)draggingExited:(id <NSDraggingInfo>)sender;
- (BOOL) prepareforDragOperation: (id <NSDraggingInfo>) sender;
- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;

@end

