#import "TinyController.h"
#import "InstallManager.h"

@implementation TinyController

- (void)info:(id)sender
{
    if (!infoPanel) {
        [NSBundle loadNibNamed:@"Info" owner:self];
    }
    [infoPanel center];
    [infoPanel orderFront:nil]; 
}

- (void)open:(id)sender
{
    int result;
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];
    NSArray *fileTypes = [[NSArray alloc] initWithObjects:@"pkg", nil];
    
    [oPanel setAllowsMultipleSelection:NO];
    [oPanel setCanChooseFiles:NO];
    [oPanel setCanChooseDirectories:YES];
    result = [oPanel runModalForDirectory:NSHomeDirectory()
                                     file:nil
                                    types:fileTypes];
    if (result == NSOKButton) {
        InstallManager *owner = [[[InstallManager alloc] init] retain];
        [NSBundle loadNibNamed:@"Package" owner:owner];
        [owner open:[oPanel filename]];
    }
}

- (BOOL)application:(NSApplication *)sender openFile:(NSString *)path
{
    InstallManager *owner = [[[InstallManager alloc] init] retain];
    [NSBundle loadNibNamed:@"Package" owner:owner];
    return [owner open:path];
}

@end
