/* Sample code for WWDC 1998 session 122: Yellow Box Foundation in Depth

You may freely use this code.  Apple provides this code as is without
warranty to its correctness or fitness for use for any purpose.
*/

/* Test program illustrating use of ThreadPerformer[DO] class */

#import "ThreadPerformer.h"
#import "ThreadPerformerDO.h"
#import <Foundation/Foundation.h>

static id mainThreadPerformer = nil;

@interface ObjectDescriber : NSObject
@end

@implementation ObjectDescriber

- (NSString *)computeDescription:(id)anObject {
    NSLog(@"current thread is: 0x%x", [NSThread currentThread]);
    return [anObject description];
}

@end

@interface Tester : NSObject
@end

@implementation Tester

- (void)doTest:(id)arg {
    id pool, result;

    pool = [[NSAutoreleasePool alloc] init];
    NSLog(@"other thread 0x%x", [NSThread currentThread]);
    result = [mainThreadPerformer performSelector:@selector(computeDescription:)
	onTarget:arg
	withObject:[NSArray arrayWithObject:[NSObject new]]];
    NSLog(@"got result '%@' in thread 0x%x", result, [NSThread currentThread]);
    [pool release];
}

@end

@interface ThreadMonitor : NSObject {
    BOOL _dead;
}
- (BOOL)threadDead;
@end

@implementation ThreadMonitor

- (id)init {
    _dead = NO;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(handleThreadExit:) name:NSThreadWillExitNotification object:nil];
    return self;
}

- (BOOL)threadDead {
    return _dead;
}

/* Since there is only one other thread, we can get away
with only one monitor object that doesn't know which thread
it is supposed to be monitoring. */
- (void)handleThreadExit:(NSNotification *)note {
    _dead = YES;
    [[NSNotificationCenter defaultCenter] removeObserver:self name:NSThreadWillExitNotification object:nil];
}

@end

void main() {
    id pool = [[NSAutoreleasePool alloc] init];
    id monitor = [[ThreadMonitor alloc] init];

#if defined(USE_DO)
    mainThreadPerformer = [ThreadPerformerDO defaultPerformer];
#else
    mainThreadPerformer = [ThreadPerformer defaultPerformer];
#endif
    NSLog(@"main thread is 0x%x", [NSThread currentThread]);
    [NSThread detachNewThreadSelector:@selector(doTest:) toTarget:[Tester new] withObject:[ObjectDescriber new]];

    // We loop until the other thread dies since
    // several messages (or 'events') might come
    // to this main thread from the other thread;
    // in the simple performer case there is 1; in
    // the D.O. case, 2; if a loop is put into the
    // doTest: method for timing purposes, many.
    while (![monitor threadDead])
	[[NSRunLoop currentRunLoop] runMode:NSDefaultRunLoopMode beforeDate:[NSDate dateWithTimeIntervalSinceNow:1.0]];

    [monitor release];
    [pool release];
    exit(0);
}

