#import <Foundation/NSObject.h>
#import <Foundation/NSArray.h>

#import "IKBrowser.h"
#import "IKIconObject.h"
#import "IKDependency.h"

@protocol IKGraphNode <IKSimpleObject, IKDependency>
- children;
- (BOOL) isLeaf;
- (BOOL) isHidden;
@end


@interface IKBrowserManager:NSObject
<IKBrowserDelegate>
{
		id	browser;
		id	root;
}
- (NSImage *) getIBImage;
- init;
- initBrowser: (id) theBrowser  root: (id) theRoot; ;
- (void)dealloc;
- awakeAfterUsingCoder:(NSCoder *)aDecoder;
- (void)doAwake;
- (IKBrowser *)browser;
- root;
- (void)setBrowser:(IKBrowser *)theBrowser; ;
- (void)setRoot: theRoot; ;
- (void)browser:sender createRowsForColumn:(int)column inMatrix:(NSMatrix *)matrix; ;
- browser: sender  setColumnIcon: cell  for: (int) column; ;
- browser: sender  emptyMatrix: matrix  inColumn: (int) column;
- browser: sender  removeColumnIcon: cell  for: (int) column;
- browserWillFinishChange: sender;
- browserDidChange: sender;
- sort: (id *) folders  count: (int) n  for: (int) column;
- (NSArray *)takePathFrom:sender;
- (void)deleteLink:(id)sender;
- (void)delete:(id)sender;
- (void)duplicate:(id)sender;
- (void)newFolder:(id)sender;
- (void)toggleLeaf:(id)sender;

@end
