
#import <Foundation/NSString.h>
#import <AppKit/NSPasteboard.h>


@protocol IKSimpleObject

- (NSString *)name;
- (NSImage *)image;
- (NSImage *)miniImage;
- (BOOL) isDraggable;
- (BOOL) isDragAccepting;
- (BOOL) isEditable;

@end


@protocol IKDraggableObject <IKSimpleObject>

- setDraggable: (BOOL) flag;
- copyToPasteboard: (NSPasteboard *) pboard;
+ readFromPasteboard: (NSPasteboard *) pboard;
+ (NSArray *) pasteTypes;

@end


@protocol IKDragAcceptingObject <IKSimpleObject>

- setDragAccepting: (BOOL) flag;
- (NSImage *)acceptingDragImage;
- (NSImage *)miniAcceptingDragImage;
- (void)setAcceptingDragImage:(NSImage *)image;
- (void)setMiniAcceptingDragImage:(NSImage *)image;

@end


@protocol IKEditableObject <IKSimpleObject>

- setName:(NSString *)name;
- (void)setImage:(NSImage *)image;
- (void)setMiniImage:(NSImage *)image;
- (void)setEditable:(BOOL)flag;

@end


@protocol IKIconObject <
				IKDraggableObject,
				IKDragAcceptingObject,
				IKEditableObject
			>
@end
