#import <Foundation/Foundation.h>

@interface SoundEffect:NSObject {
    id sound;				// The sound data for this sound
    struct {
        unsigned int refCount:24;	// Number of play requests pending
	unsigned int freeWhenDone:1;	// Free when all are done
	unsigned int :7;
    } flags;
}

// Create a SoundEffect from a resource in the app...
- (id)initWithSoundResource:(NSString *)soundName;

// Play the SoundEffect
- (void)play;
- (void)play:(float)volume pan:(float)rads;

// Globally disable/enable sound playing
+ (void)setSoundEnabled:(BOOL)flag;
+ (BOOL)soundEnabled;

// How many sounds can be played simultaneously?
+ (void)setMaxSoundStreams:(unsigned int)max;
+ (unsigned int)maxSoundStreams;

@end

