//
//	MiscAppIconAnimator.h -- This is an Object to animate the icon
//				for an application.  This Object will allow
//				similiar activity to NeXTMail when new mail arrives.
//		Written by Craig Laurent Copyright 1995 by Craig Laurent.
//				Version 1.1.  All rights reserved.
//
//		This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	
#import <AppKit/AppKit.h>
//#import <eointerface/eointerface.h>

//** extra code used for encoding a subclass of NSObject
//@interface NSObject (NXTransportExtensions)
//- replacementObjectForPortCoder:(NSPortCoder *)aPortCoder;
//@end


/* MiscAppIconAnimator. - an Object to animate the icon for an application.  This Object will allow similiar activity to NeXTMail when new mail arrives.  Pass in an array of NSImages, an array of NSNumbers indicating the pattern, and the number of loops through the pattern to execute.  The time interval between image changes, and the stopAnimation icon can be set after initialization.

imageArray - an array of NSImages to be placed in the icon one at a time.
animationPattern - an array of NSNumbers.  Each number indicates which image number (objectAt:) should be displayed.  The order of the numbers will reflect the pattern of the animation.
patternLoops - the number of times that the animationPattern will be looped through.
timeInterval - the time interval between image changes.  Defaults to 0.2 seconds.  See setTimeInterval: method.
indexOfEndIcon - the index of the icon to be displayed at the end of the animation cycle.  Defaults to 1.  See setIndexOfEndIcon: method.
indexOfStopIcon - the index of the icon to be displayed after stopAnimation:.  Defaults to 0.  See setIndexOfStopIcon: method.
*/

@interface MiscAppIconAnimator:NSObject <NSCoding>
{
	NSImage	*appTile;
	NSView	*appIconContentView;

	NSMutableArray	*animationPattern;
	NSMutableArray	*imageArray;
	int	patternLoops;
	float	timeInterval;
	int	indexOfEndIcon;
	int	indexOfStopIcon;

	NSTimer *timedEntry;
	int	patternIterator;
	int	loopCount;
	int	patternEnd;
	int	offset;
}

void Animate (NSTimer *timedEntry, double  now, void *who);

- init;
- initWithImageArray:(NSArray*)anArray animationPattern:(NSArray*)patternArray andPatternLoops:(int)loops;	//designated initializer
- (void)dealloc;

//** instance methods
- (NSArray*)imageArray;
- (void)setImageArray:(NSArray*)anArray;
- (NSArray*)animationPattern;
- (void)setAnimationPattern:(NSArray*)anArray;
- (int)patternLoops;
- (void)setPatternLoops:(int)numLoops;
- (float)timeInterval;
- (void)setTimeInterval:(float)interval;
- (int)indexOfEndIcon;
- (void)setIndexOfEndIcon:(int)endIcon;
- (int)indexOfStopIcon;
- (void)setIndexOfStopIcon:(int)stopIcon;

//** methods to change Animation
- (void)startAnimation:sender;
- (void)stopAnimation;


//** Internal methods
- (void)removeTimedEntry;
- (NSPoint)cornerPointForImage:(NSImage*)anImage;
- (void)displayImage:(NSImage*)anImage;
- (void)displayImageAtIndex:(int)imageNum;
- (void)animateIcon:(NSTimer *)theTimer;


//** data archiving methods
- (void)encodeWithCoder:(NSCoder *)aCoder;
- initWithCoder:(NSCoder *)aDecoder;

//** Distributed Object methods
- replacementObjectForPortCoder:(NSPortCoder *)aPortCoder;

@end
